/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.support.fixed;

import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.threadlocal.NamedInternalThreadFactory;
import org.apache.dubbo.common.threadpool.MemorySafeLinkedBlockingQueue;
import org.apache.dubbo.common.threadpool.ThreadPool;
import org.apache.dubbo.common.threadpool.support.AbortPolicyWithReport;

public class FixedThreadPool
implements ThreadPool {
    @Override
    public Executor getExecutor(URL url) {
        String name = url.getParameter("threadname", (String)url.getAttribute("threadname", "Dubbo"));
        int threads = url.getParameter("threads", 200);
        int queues = url.getParameter("queues", 0);
        AbstractQueue blockingQueue = queues == 0 ? new SynchronousQueue() : (queues < 0 ? new MemorySafeLinkedBlockingQueue() : new LinkedBlockingQueue(queues));
        return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)blockingQueue), new NamedInternalThreadFactory(name, true), new AbortPolicyWithReport(name, url));
    }
}

