/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.aggregate;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.LongAdder;
import org.apache.dubbo.metrics.aggregate.Pane;
import org.apache.dubbo.metrics.aggregate.SampleAggregatedEntry;
import org.apache.dubbo.metrics.aggregate.SlidingWindow;

public class TimeWindowAggregator {
    private final SnapshotSlidingWindow slidingWindow;

    public TimeWindowAggregator(int bucketNum, int timeWindowSeconds) {
        this.slidingWindow = new SnapshotSlidingWindow(bucketNum, TimeUnit.SECONDS.toMillis(timeWindowSeconds));
    }

    public SnapshotSlidingWindow getSlidingWindow() {
        return this.slidingWindow;
    }

    public void add(double value) {
        SnapshotObservation sample = (SnapshotObservation)this.slidingWindow.currentPane().getValue();
        sample.add(value);
    }

    public SampleAggregatedEntry get() {
        SampleAggregatedEntry aggregatedEntry = new SampleAggregatedEntry();
        double total = 0.0;
        long count = 0L;
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        List windows = this.slidingWindow.values();
        for (SnapshotObservation window : windows) {
            total += window.getTotal().doubleValue();
            count += window.getCount();
            max = Math.max(max, window.getMax());
            min = Math.min(min, window.getMin());
        }
        if (count > 0L) {
            double avg = total / (double)count;
            aggregatedEntry.setAvg((double)Math.round(avg * 100.0) / 100.0);
        } else {
            aggregatedEntry.setAvg(0.0);
        }
        aggregatedEntry.setMax(max == Double.MIN_VALUE ? 0.0 : max);
        aggregatedEntry.setMin(min == Double.MAX_VALUE ? 0.0 : min);
        aggregatedEntry.setTotal(total);
        aggregatedEntry.setCount(count);
        return aggregatedEntry;
    }

    public static class SnapshotObservation {
        private final AtomicReference<Double> min = new AtomicReference<Double>((Double)Double.MAX_VALUE);
        private final AtomicReference<Double> max = new AtomicReference<Double>(0.0);
        private final DoubleAccumulator total = new DoubleAccumulator((x, y) -> x + y, 0.0);
        private final LongAdder count = new LongAdder();

        public void add(double sample) {
            this.total.accumulate(sample);
            this.count.increment();
            this.updateMin(sample);
            this.updateMax(sample);
        }

        private void updateMin(double sample) {
            Double curMin;
            while (sample < (curMin = this.min.get()) && !this.min.compareAndSet(curMin, sample)) {
            }
        }

        private void updateMax(double sample) {
            Double curMax;
            do {
                if (!(sample <= (curMax = this.max.get()))) continue;
                return;
            } while (!this.max.compareAndSet(curMax, sample));
        }

        public void reset() {
            this.min.set((Double)Double.MAX_VALUE);
            this.max.set(0.0);
            this.count.reset();
            this.total.reset();
        }

        public double getMin() {
            return this.min.get();
        }

        public double getMax() {
            return this.max.get();
        }

        public Double getTotal() {
            return this.total.get();
        }

        public long getCount() {
            return this.count.sum();
        }
    }

    public static class SnapshotSlidingWindow
    extends SlidingWindow<SnapshotObservation> {
        public SnapshotSlidingWindow(int sampleCount, long intervalInMs) {
            super(sampleCount, intervalInMs);
        }

        @Override
        public SnapshotObservation newEmptyValue(long timeMillis) {
            return new SnapshotObservation();
        }

        @Override
        protected Pane<SnapshotObservation> resetPaneTo(Pane<SnapshotObservation> pane, long startTime) {
            pane.setStartInMs(startTime);
            pane.getValue().reset();
            return pane;
        }
    }
}

