/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.security.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.security.jackson2.CoreJackson2Module;

public class ObjectMapperCodec {
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectMapperCodec() {
        this.registerDefaultModule();
    }

    public <T> T deserialize(byte[] bytes, Class<T> clazz) {
        try {
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            return (T)this.mapper.readValue(bytes, clazz);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("objectMapper! deserialize error %s", exception));
        }
    }

    public <T> T deserialize(String content, Class<T> clazz) {
        if (StringUtils.isBlank(content)) {
            return null;
        }
        return this.deserialize(content.getBytes(), clazz);
    }

    public String serialize(Object object) {
        try {
            if (object == null) {
                return null;
            }
            return this.mapper.writeValueAsString(object);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("objectMapper! serialize error %s", ex));
        }
    }

    public ObjectMapperCodec addModule(SimpleModule simpleModule) {
        this.mapper.registerModule((Module)simpleModule);
        return this;
    }

    public ObjectMapperCodec configureMapper(Consumer<ObjectMapper> objectMapperConfigure) {
        objectMapperConfigure.accept(this.mapper);
        return this;
    }

    private void registerDefaultModule() {
        this.mapper.registerModule((Module)new CoreJackson2Module());
        this.mapper.registerModule((Module)new JavaTimeModule());
        ArrayList<String> jacksonModuleClassNameList = new ArrayList<String>();
        jacksonModuleClassNameList.add("org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module");
        jacksonModuleClassNameList.add("org.springframework.security.oauth2.client.jackson2.OAuth2ClientJackson2Module");
        jacksonModuleClassNameList.add("org.springframework.security.web.server.jackson2.WebServerJackson2Module");
        jacksonModuleClassNameList.add("com.fasterxml.jackson.module.paramnames.ParameterNamesModule");
        jacksonModuleClassNameList.add("org.springframework.security.web.jackson2.WebServletJackson2Module");
        jacksonModuleClassNameList.add("org.springframework.security.web.jackson2.WebJackson2Module");
        jacksonModuleClassNameList.add("org.springframework.boot.jackson.JsonMixinModule");
        jacksonModuleClassNameList.add("org.springframework.security.ldap.jackson2.LdapJackson2Module");
        this.loadModuleIfPresent(jacksonModuleClassNameList);
    }

    private void loadModuleIfPresent(List<String> jacksonModuleClassNameList) {
        for (String moduleClassName : jacksonModuleClassNameList) {
            try {
                SimpleModule objectMapperModule = (SimpleModule)ClassUtils.forName(moduleClassName, ObjectMapperCodec.class.getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.mapper.registerModule((Module)objectMapperModule);
            }
            catch (Throwable throwable) {}
        }
    }
}

