/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.security.filter;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.spring.security.jackson.ObjectMapperCodec;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@Activate(group={"consumer"}, order=-10000, onClass={"org.springframework.security.core.context.SecurityContextHolder"})
public class ContextHolderAuthenticationPrepareFilter
implements ClusterFilter {
    private final ObjectMapperCodec mapper;

    public ContextHolderAuthenticationPrepareFilter(ApplicationModel applicationModel) {
        this.mapper = applicationModel.getBeanFactory().getBean(ObjectMapperCodec.class);
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        this.setSecurityContext(invocation);
        return invoker.invoke(invocation);
    }

    private void setSecurityContext(Invocation invocation) {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        invocation.setObjectAttachment("security_authentication_context", this.mapper.serialize(authentication));
    }
}

