/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.ThreadPool;
import org.apache.dubbo.rpc.protocol.rest.RestHeaderEnum;
import org.apache.dubbo.rpc.protocol.rest.handler.NettyHttpHandler;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyHttpResponse;
import org.apache.dubbo.rpc.protocol.rest.request.NettyRequestFacade;

public class RestHttpRequestDecoder
extends MessageToMessageDecoder<FullHttpRequest> {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(((Object)((Object)this)).getClass());
    private final NettyHttpHandler handler;
    private final Executor executor;

    public RestHttpRequestDecoder(NettyHttpHandler handler, URL url) {
        this.handler = handler;
        this.executor = url.getOrDefaultFrameworkModel().getExtensionLoader(ThreadPool.class).getAdaptiveExtension().getExecutor(url);
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpRequest request, List<Object> out) throws Exception {
        boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
        NettyHttpResponse nettyHttpResponse = new NettyHttpResponse(ctx, keepAlive);
        NettyRequestFacade requestFacade = new NettyRequestFacade(request, ctx);
        this.executor.execute(() -> {
            try {
                this.handler.handle(requestFacade, nettyHttpResponse);
            }
            catch (IOException e) {
                this.logger.error("", e.getCause().getMessage(), "dubbo rest rest http request handler error", e.getMessage(), e);
            }
            finally {
                try {
                    nettyHttpResponse.addOutputHeaders(RestHeaderEnum.CONNECTION.getHeader(), "close");
                    nettyHttpResponse.finish();
                }
                catch (IOException e) {
                    this.logger.error("", e.getCause().getMessage(), "dubbo rest rest http response flush error", e.getMessage(), e);
                }
            }
        });
    }
}

