/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.message.codec;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodec;

@Activate(value={"string"})
public class StringCodec
implements HttpMessageCodec<byte[], OutputStream> {
    @Override
    public Object decode(byte[] body, Class<?> targetType) throws Exception {
        if (body == null || body.length == 0) {
            return null;
        }
        return new String(body);
    }

    @Override
    public boolean contentTypeSupport(MediaType mediaType, Class<?> targetType) {
        return String.class.equals(targetType);
    }

    @Override
    public boolean typeSupport(Class<?> targetType) {
        return String.class.equals(targetType);
    }

    @Override
    public MediaType contentType() {
        return MediaType.TEXT_PLAIN;
    }

    @Override
    public void encode(OutputStream outputStream, Object unSerializedBody, URL url) throws Exception {
        outputStream.write(((String)unSerializedBody).getBytes(StandardCharsets.UTF_8));
    }
}

