/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.message;

import java.io.OutputStream;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.rest.exception.UnSupportContentTypeException;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodec;
import org.apache.dubbo.rpc.protocol.rest.pair.MessageCodecResultPair;

public class HttpMessageCodecManager {
    private static final Set<HttpMessageCodec> httpMessageCodecs = FrameworkModel.defaultModel().getExtensionLoader(HttpMessageCodec.class).getSupportedExtensionInstances();

    public static Object httpMessageDecode(byte[] body, Class<?> type, MediaType mediaType) throws Exception {
        if (body == null || body.length == 0) {
            return null;
        }
        for (HttpMessageCodec httpMessageCodec : httpMessageCodecs) {
            if (!httpMessageCodec.contentTypeSupport(mediaType, type) && !HttpMessageCodecManager.typeJudge(mediaType, type, httpMessageCodec)) continue;
            return httpMessageCodec.decode(body, type);
        }
        throw new UnSupportContentTypeException("UnSupport content-type :" + mediaType.value);
    }

    public static MessageCodecResultPair httpMessageEncode(OutputStream outputStream, Object unSerializedBody, URL url, MediaType mediaType, Class<?> bodyType) throws Exception {
        if (unSerializedBody == null) {
            for (HttpMessageCodec httpMessageCodec : httpMessageCodecs) {
                if (!httpMessageCodec.contentTypeSupport(mediaType, bodyType) && !HttpMessageCodecManager.typeJudge(mediaType, bodyType, httpMessageCodec)) continue;
                return MessageCodecResultPair.pair(false, httpMessageCodec.contentType());
            }
        }
        for (HttpMessageCodec httpMessageCodec : httpMessageCodecs) {
            if (!httpMessageCodec.contentTypeSupport(mediaType, bodyType) && !HttpMessageCodecManager.typeJudge(mediaType, bodyType, httpMessageCodec)) continue;
            httpMessageCodec.encode(outputStream, unSerializedBody, url);
            return MessageCodecResultPair.pair(true, httpMessageCodec.contentType());
        }
        throw new UnSupportContentTypeException("UnSupport content-type :" + mediaType.value);
    }

    private static boolean typeJudge(MediaType mediaType, Class<?> bodyType, HttpMessageCodec httpMessageCodec) {
        return (MediaType.ALL_VALUE.equals((Object)mediaType) || mediaType == null) && bodyType != null && httpMessageCodec.typeSupport(bodyType);
    }

    public static MediaType typeSupport(Class<?> type) {
        for (HttpMessageCodec httpMessageCodec : httpMessageCodecs) {
            if (!httpMessageCodec.typeSupport(type)) continue;
            return httpMessageCodec.contentType();
        }
        return null;
    }
}

