/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.exception.mapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.ExceptionHandler;
import org.apache.dubbo.rpc.protocol.rest.util.ReflectUtils;

public class ExceptionMapper {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final Map<Class<?>, ExceptionHandler> exceptionHandlerMap = new ConcurrentHashMap();

    public Object exceptionToResult(Object throwable) {
        if (!this.hasExceptionMapper(throwable)) {
            return throwable;
        }
        return this.exceptionHandlerMap.get(throwable.getClass()).result((Throwable)throwable);
    }

    public boolean hasExceptionMapper(Object throwable) {
        if (throwable == null) {
            return false;
        }
        return this.exceptionHandlerMap.containsKey(throwable.getClass());
    }

    public void registerMapper(Class<?> exceptionHandler) {
        try {
            List<Constructor<?>> constructors;
            if (!ExceptionHandler.class.isAssignableFrom(exceptionHandler)) {
                return;
            }
            List<Method> methods = ReflectUtils.getMethodByNameList(exceptionHandler, "result");
            HashSet exceptions = new HashSet();
            for (Method method : methods) {
                Class<?> parameterType = method.getParameterTypes()[0];
                if (!Throwable.class.isAssignableFrom(parameterType)) continue;
                exceptions.add(parameterType);
            }
            ArrayList classes = new ArrayList(exceptions);
            if (classes.size() != 1) {
                exceptions.remove(Throwable.class);
            }
            if ((constructors = ReflectUtils.getConstructList(exceptionHandler)).isEmpty()) {
                throw new RuntimeException("dubbo rest exception mapper register mapper need exception handler exist no  construct declare, current class is: " + exceptionHandler);
            }
            Object handler = constructors.get(0).newInstance(new Object[constructors.get(0).getParameterCount()]);
            for (Class clazz : exceptions) {
                this.exceptionHandlerMap.put(clazz, (ExceptionHandler)handler);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("dubbo rest protocol exception mapper register error ", e);
        }
    }

    public void registerMapper(String exceptionMapper) {
        try {
            this.registerMapper(ReflectUtils.findClass(exceptionMapper));
        }
        catch (Exception e) {
            this.logger.warn("", e.getMessage(), "", "dubbo rest protocol exception mapper register error ,and current exception mapper is  :" + exceptionMapper);
        }
    }

    public void unRegisterMapper(Class<?> exception) {
        this.exceptionHandlerMap.remove(exception);
    }
}

