/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.rest.RestConstraintViolation;
import org.apache.dubbo.rpc.protocol.rest.ViolationReport;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.ExceptionHandler;

public class RpcExceptionMapper
implements ExceptionHandler<RpcException> {
    protected Object handleConstraintViolationException(ConstraintViolationException cve) {
        ViolationReport report = new ViolationReport();
        for (ConstraintViolation cv : cve.getConstraintViolations()) {
            report.addConstraintViolation(new RestConstraintViolation(cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue() == null ? "null" : cv.getInvalidValue().toString()));
        }
        return report;
    }

    @Override
    public Object result(RpcException e) {
        if (e.getCause() instanceof ConstraintViolationException) {
            return this.handleConstraintViolationException((ConstraintViolationException)e.getCause());
        }
        return "Internal server error: " + e.getMessage();
    }
}

