/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.rest.PathMatcher;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.protocol.rest.PathAndInvokerMapper;
import org.apache.dubbo.rpc.protocol.rest.RestProtocolServer;
import org.apache.dubbo.rpc.protocol.rest.RpcExceptionMapper;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.ExceptionMapper;
import org.apache.dubbo.rpc.protocol.rest.handler.NettyHttpHandler;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyServer;
import org.apache.dubbo.rpc.protocol.rest.netty.RestHttpRequestDecoder;
import org.apache.dubbo.rpc.protocol.rest.netty.UnSharedHandlerCreator;

public class NettyHttpRestServer
implements RestProtocolServer {
    private final PathAndInvokerMapper pathAndInvokerMapper = new PathAndInvokerMapper();
    private final ExceptionMapper exceptionMapper = new ExceptionMapper();
    private NettyServer server = this.getNettyServer();
    private String address;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    protected NettyServer getNettyServer() {
        return new NettyServer();
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public void close() {
        this.server.stop();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public void start(URL url) {
        this.registerExceptionMapper(url);
        String bindIp = url.getParameter("bind.ip", url.getHost());
        if (!url.isAnyHost() && NetUtils.isValidLocalHost(bindIp)) {
            this.server.setHostname(bindIp);
        }
        this.server.setPort(url.getParameter("bind.port", url.getPort()));
        this.server.setChildChannelOptions(this.getChildChannelOptionMap(url));
        this.server.setChannelOptions(this.getChannelOptionMap(url));
        this.server.setUnSharedHandlerCallBack(this.getUnSharedHttpChannelHandlers());
        this.server.setChannelHandlers(this.getChannelHandlers(url));
        this.server.setIoWorkerCount(url.getParameter("iothreads", Constants.DEFAULT_IO_THREADS));
        this.server.start(url);
    }

    private UnSharedHandlerCreator getUnSharedHttpChannelHandlers() {
        return new UnSharedHandlerCreator(){

            @Override
            public List<ChannelHandler> getUnSharedHandlers(URL url) {
                return Arrays.asList(new ChannelHandler[]{new HttpRequestDecoder(url.getParameter("max.initial.line.length", 4096), url.getParameter("max.header.size", 8192), url.getParameter("max.chunk.size", 8192)), new HttpObjectAggregator(url.getParameter("max.request.size", 0xA00000)), new HttpResponseEncoder(), new RestHttpRequestDecoder(new NettyHttpHandler(NettyHttpRestServer.this.pathAndInvokerMapper, NettyHttpRestServer.this.exceptionMapper), url)});
            }
        };
    }

    protected Map<ChannelOption, Object> getChildChannelOptionMap(URL url) {
        HashMap<ChannelOption, Object> channelOption = new HashMap<ChannelOption, Object>();
        channelOption.put(ChannelOption.SO_KEEPALIVE, url.getParameter("keepalive", true));
        return channelOption;
    }

    protected Map<ChannelOption, Object> getChannelOptionMap(URL url) {
        HashMap<ChannelOption, Object> options = new HashMap<ChannelOption, Object>();
        options.put(ChannelOption.SO_REUSEADDR, Boolean.TRUE);
        options.put(ChannelOption.TCP_NODELAY, Boolean.TRUE);
        options.put(ChannelOption.SO_BACKLOG, url.getPositiveParameter("backlog", 1024));
        options.put(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        return options;
    }

    protected List<ChannelHandler> getChannelHandlers(URL url) {
        ArrayList<ChannelHandler> channelHandlers = new ArrayList<ChannelHandler>();
        return channelHandlers;
    }

    @Override
    public void deploy(ServiceRestMetadata serviceRestMetadata, Invoker invoker) {
        Map<PathMatcher, RestMethodMetadata> pathToServiceMapContainPathVariable = serviceRestMetadata.getPathContainPathVariableToServiceMap();
        this.pathAndInvokerMapper.addPathAndInvoker(pathToServiceMapContainPathVariable, invoker);
        Map<PathMatcher, RestMethodMetadata> pathToServiceMapUnContainPathVariable = serviceRestMetadata.getPathUnContainPathVariableToServiceMap();
        this.pathAndInvokerMapper.addPathAndInvoker(pathToServiceMapUnContainPathVariable, invoker);
    }

    @Override
    public void undeploy(ServiceRestMetadata serviceRestMetadata) {
        Map<PathMatcher, RestMethodMetadata> pathToServiceMapContainPathVariable = serviceRestMetadata.getPathContainPathVariableToServiceMap();
        pathToServiceMapContainPathVariable.keySet().stream().forEach(this.pathAndInvokerMapper::removePath);
        Map<PathMatcher, RestMethodMetadata> pathToServiceMapUnContainPathVariable = serviceRestMetadata.getPathUnContainPathVariableToServiceMap();
        pathToServiceMapUnContainPathVariable.keySet().stream().forEach(this.pathAndInvokerMapper::removePath);
    }

    private void registerExceptionMapper(URL url) {
        for (String clazz : CommonConstants.COMMA_SPLIT_PATTERN.split(url.getParameter("extension", RpcExceptionMapper.class.getName()))) {
            if (StringUtils.isEmpty(clazz)) continue;
            this.exceptionMapper.registerMapper(clazz);
        }
    }
}

