/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo.filter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.model.AsyncMethodInfo;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ServiceModel;

@Activate(group={"consumer"})
public class FutureFilter
implements ClusterFilter,
BaseFilter.Listener {
    protected static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(FutureFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        this.fireInvokeCallback(invoker, invocation);
        return invoker.invoke(invocation);
    }

    @Override
    public void onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        if (result.hasException()) {
            this.fireThrowCallback(invoker, invocation, result.getException());
        } else {
            this.fireReturnCallback(invoker, invocation, result.getValue());
        }
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        this.fireThrowCallback(invoker, invocation, t);
    }

    private void fireInvokeCallback(Invoker<?> invoker, Invocation invocation) {
        AsyncMethodInfo asyncMethodInfo = this.getAsyncMethodInfo(invoker, invocation);
        if (asyncMethodInfo == null) {
            return;
        }
        Method onInvokeMethod = asyncMethodInfo.getOninvokeMethod();
        Object onInvokeInst = asyncMethodInfo.getOninvokeInstance();
        if (onInvokeMethod == null && onInvokeInst == null) {
            return;
        }
        if (onInvokeMethod == null || onInvokeInst == null) {
            throw new IllegalStateException("service:" + invoker.getUrl().getServiceKey() + " has a oninvoke callback config , but no such " + (onInvokeMethod == null ? "method" : "instance") + " found. url:" + invoker.getUrl());
        }
        if (!onInvokeMethod.isAccessible()) {
            onInvokeMethod.setAccessible(true);
        }
        Object[] params = invocation.getArguments();
        try {
            onInvokeMethod.invoke(onInvokeInst, params);
        }
        catch (InvocationTargetException e) {
            this.fireThrowCallback(invoker, invocation, e.getTargetException());
        }
        catch (Throwable e) {
            this.fireThrowCallback(invoker, invocation, e);
        }
    }

    private void fireReturnCallback(Invoker<?> invoker, Invocation invocation, Object result) {
        Object[] params;
        AsyncMethodInfo asyncMethodInfo = this.getAsyncMethodInfo(invoker, invocation);
        if (asyncMethodInfo == null) {
            return;
        }
        Method onReturnMethod = asyncMethodInfo.getOnreturnMethod();
        Object onReturnInst = asyncMethodInfo.getOnreturnInstance();
        if (onReturnMethod == null && onReturnInst == null) {
            return;
        }
        if (onReturnMethod == null || onReturnInst == null) {
            throw new IllegalStateException("service:" + invoker.getUrl().getServiceKey() + " has a onreturn callback config , but no such " + (onReturnMethod == null ? "method" : "instance") + " found. url:" + invoker.getUrl());
        }
        if (!onReturnMethod.isAccessible()) {
            onReturnMethod.setAccessible(true);
        }
        Object[] args = invocation.getArguments();
        Class<?>[] rParaTypes = onReturnMethod.getParameterTypes();
        if (rParaTypes.length > 1) {
            if (rParaTypes.length == 2 && rParaTypes[1].isAssignableFrom(Object[].class)) {
                params = new Object[]{result, args};
            } else {
                params = new Object[args.length + 1];
                params[0] = result;
                System.arraycopy(args, 0, params, 1, args.length);
            }
        } else {
            params = new Object[]{result};
        }
        try {
            onReturnMethod.invoke(onReturnInst, params);
        }
        catch (InvocationTargetException e) {
            this.fireThrowCallback(invoker, invocation, e.getTargetException());
        }
        catch (Throwable e) {
            this.fireThrowCallback(invoker, invocation, e);
        }
    }

    private void fireThrowCallback(Invoker<?> invoker, Invocation invocation, Throwable exception) {
        Class<?>[] rParaTypes;
        AsyncMethodInfo asyncMethodInfo = this.getAsyncMethodInfo(invoker, invocation);
        if (asyncMethodInfo == null) {
            return;
        }
        Method onthrowMethod = asyncMethodInfo.getOnthrowMethod();
        Object onthrowInst = asyncMethodInfo.getOnthrowInstance();
        if (onthrowMethod == null && onthrowInst == null) {
            return;
        }
        if (onthrowMethod == null || onthrowInst == null) {
            throw new IllegalStateException("service:" + invoker.getUrl().getServiceKey() + " has a onthrow callback config , but no such " + (onthrowMethod == null ? "method" : "instance") + " found. url:" + invoker.getUrl());
        }
        if (!onthrowMethod.isAccessible()) {
            onthrowMethod.setAccessible(true);
        }
        if ((rParaTypes = onthrowMethod.getParameterTypes())[0].isAssignableFrom(exception.getClass())) {
            try {
                Object[] params;
                Object[] args = invocation.getArguments();
                if (rParaTypes.length > 1) {
                    if (rParaTypes.length == 2 && rParaTypes[1].isAssignableFrom(Object[].class)) {
                        params = new Object[]{exception, args};
                    } else {
                        params = new Object[args.length + 1];
                        params[0] = exception;
                        System.arraycopy(args, 0, params, 1, args.length);
                    }
                } else {
                    params = new Object[]{exception};
                }
                onthrowMethod.invoke(onthrowInst, params);
            }
            catch (Throwable e) {
                logger.error("4-11", "", "", invocation.getMethodName() + ".call back method invoke error . callback method :" + onthrowMethod + ", url:" + invoker.getUrl(), e);
            }
        } else {
            logger.error("4-11", "", "", invocation.getMethodName() + ".call back method invoke error . callback method :" + onthrowMethod + ", url:" + invoker.getUrl(), exception);
        }
    }

    private AsyncMethodInfo getAsyncMethodInfo(Invoker<?> invoker, Invocation invocation) {
        AsyncMethodInfo asyncMethodInfo = (AsyncMethodInfo)invocation.get("async-method-info");
        if (asyncMethodInfo != null) {
            return asyncMethodInfo;
        }
        ServiceModel serviceModel = invocation.getServiceModel();
        if (!(serviceModel instanceof ConsumerModel)) {
            return null;
        }
        String methodName = invocation.getMethodName();
        if (methodName.equals("$invoke")) {
            methodName = (String)invocation.getArguments()[0];
        }
        return ((ConsumerModel)serviceModel).getAsyncInfo(methodName);
    }
}

