/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.istio;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.xds.XdsEnv;

public class IstioEnv
implements XdsEnv {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(IstioEnv.class);
    private static final IstioEnv INSTANCE = new IstioEnv();
    private String podName;
    private String caAddr;
    private String jwtPolicy = Optional.ofNullable(System.getenv("JWT_POLICY")).orElse("first-party-jwt");
    private String trustDomain;
    private String workloadNameSpace;
    private int rasKeySize;
    private String eccSigAlg;
    private int secretTTL;
    private float secretGracePeriodRatio;
    private String istioMetaClusterId;
    private String pilotCertProvider;

    private IstioEnv() {
        this.podName = Optional.ofNullable(System.getenv("POD_NAME")).orElse(System.getenv("HOSTNAME"));
        this.trustDomain = Optional.ofNullable(System.getenv("TRUST_DOMAIN")).orElse("cluster.local");
        this.workloadNameSpace = Optional.ofNullable(System.getenv("WORKLOAD_NAMESPACE")).orElseGet(() -> {
            File namespaceFile = new File("/var/run/secrets/kubernetes.io/serviceaccount/namespace");
            if (namespaceFile.canRead()) {
                try {
                    return FileUtils.readFileToString((File)namespaceFile, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    logger.error("1-29", "", "", "read namespace file error", e);
                }
            }
            return "default";
        });
        this.caAddr = Optional.ofNullable(System.getenv("CA_ADDR")).orElse("istiod.istio-system.svc:15012");
        this.rasKeySize = Integer.parseInt(Optional.ofNullable(System.getenv("RSA_KEY_SIZE")).orElse("2048"));
        this.eccSigAlg = Optional.ofNullable(System.getenv("ECC_SIGNATURE_ALGORITHM")).orElse("ECDSA");
        this.secretTTL = Integer.parseInt(Optional.ofNullable(System.getenv("SECRET_TTL")).orElse("86400"));
        this.secretGracePeriodRatio = Float.parseFloat(Optional.ofNullable(System.getenv("SECRET_GRACE_PERIOD_RATIO")).orElse("0.5"));
        this.istioMetaClusterId = Optional.ofNullable(System.getenv("ISTIO_META_CLUSTER_ID")).orElse("Kubernetes");
        this.pilotCertProvider = Optional.ofNullable(System.getenv("PILOT_CERT_PROVIDER")).orElse("");
        if (this.getServiceAccount() == null) {
            throw new UnsupportedOperationException("Unable to found kubernetes service account token file. Please check if work in Kubernetes and mount service account token file correctly.");
        }
    }

    public static IstioEnv getInstance() {
        return INSTANCE;
    }

    public String getPodName() {
        return this.podName;
    }

    public String getCaAddr() {
        return this.caAddr;
    }

    public String getServiceAccount() {
        File saFile;
        switch (this.jwtPolicy) {
            case "first-party-jwt": {
                saFile = new File("/var/run/secrets/kubernetes.io/serviceaccount/token");
                break;
            }
            default: {
                saFile = new File("/var/run/secrets/tokens/istio-token");
            }
        }
        if (saFile.canRead()) {
            try {
                return FileUtils.readFileToString((File)saFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                logger.error("1-41", "File Read Failed", "", "Unable to read token file.", e);
            }
        }
        return null;
    }

    public String getCsrHost() {
        return "spiffe://" + this.trustDomain + "/ns/" + this.workloadNameSpace + "/sa/" + this.getServiceAccount();
    }

    public String getTrustDomain() {
        return this.trustDomain;
    }

    public String getWorkloadNameSpace() {
        return this.workloadNameSpace;
    }

    @Override
    public String getCluster() {
        return null;
    }

    public int getRasKeySize() {
        return this.rasKeySize;
    }

    public boolean isECCFirst() {
        return "ECDSA".equals(this.eccSigAlg);
    }

    public int getSecretTTL() {
        return this.secretTTL;
    }

    public float getSecretGracePeriodRatio() {
        return this.secretGracePeriodRatio;
    }

    public String getIstioMetaClusterId() {
        return this.istioMetaClusterId;
    }

    public String getCaCert() {
        if (!"istiod".equals(this.pilotCertProvider)) {
            return null;
        }
        File caFile = new File("/var/run/secrets/istio/root-cert.pem");
        if (caFile.canRead()) {
            try {
                return FileUtils.readFileToString((File)caFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                logger.error("1-41", "File Read Failed", "", "read ca file error", e);
            }
        }
        return null;
    }
}

