/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.DubboServiceAddressURL;
import org.apache.dubbo.common.url.component.ServiceAddressURL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;
import org.apache.dubbo.registry.AddressListener;
import org.apache.dubbo.registry.integration.AbstractConfiguratorListener;
import org.apache.dubbo.registry.integration.DynamicDirectory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.support.ClusterUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class RegistryDirectory<T>
extends DynamicDirectory<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(RegistryDirectory.class);
    private final ConsumerConfigurationListener consumerConfigurationListener;
    private ReferenceConfigurationListener referenceConfigurationListener;
    protected volatile Map<URL, Invoker<T>> urlInvokerMap;
    protected volatile Set<URL> cachedInvokerUrls;
    private final ModuleModel moduleModel;

    public RegistryDirectory(Class<T> serviceType, URL url) {
        super(serviceType, url);
        this.moduleModel = ScopeModelUtil.getModuleModel(url.getScopeModel());
        this.consumerConfigurationListener = this.getConsumerConfigurationListener(this.moduleModel);
    }

    @Override
    public void subscribe(URL url) {
        ApplicationModel applicationModel = url.getApplicationModel();
        MetricsEventBus.post(RegistryEvent.toSubscribeEvent(applicationModel), () -> {
            super.subscribe(url);
            return null;
        });
        if (this.moduleModel.getModelEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", true).booleanValue()) {
            this.consumerConfigurationListener.addNotifyListener(this);
            this.referenceConfigurationListener = new ReferenceConfigurationListener(this.moduleModel, this, url);
        }
    }

    private ConsumerConfigurationListener getConsumerConfigurationListener(ModuleModel moduleModel) {
        return moduleModel.getBeanFactory().getOrRegisterBean(ConsumerConfigurationListener.class, type -> new ConsumerConfigurationListener(moduleModel));
    }

    @Override
    public void unSubscribe(URL url) {
        super.unSubscribe(url);
        if (this.moduleModel.getModelEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", true).booleanValue()) {
            this.consumerConfigurationListener.removeNotifyListener(this);
            if (this.referenceConfigurationListener != null) {
                this.referenceConfigurationListener.stop();
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.moduleModel.getModelEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", true).booleanValue()) {
            this.consumerConfigurationListener.removeNotifyListener(this);
            if (this.referenceConfigurationListener != null) {
                this.referenceConfigurationListener.stop();
            }
        }
    }

    @Override
    public synchronized void notify(List<URL> urls) {
        if (this.isDestroyed()) {
            return;
        }
        Map<String, List<URL>> categoryUrls = urls.stream().filter(Objects::nonNull).filter(this::isValidCategory).filter(this::isNotCompatibleFor26x).collect(Collectors.groupingBy(this::judgeCategory));
        List<URL> configuratorURLs = categoryUrls.getOrDefault("configurators", Collections.emptyList());
        this.configurators = Configurator.toConfigurators(configuratorURLs).orElse(this.configurators);
        List<URL> routerURLs = categoryUrls.getOrDefault("routers", Collections.emptyList());
        this.toRouters(routerURLs).ifPresent(this::addRouters);
        List<URL> providerURLs = categoryUrls.getOrDefault("providers", Collections.emptyList());
        ExtensionLoader<AddressListener> addressListenerExtensionLoader = this.getUrl().getOrDefaultModuleModel().getExtensionLoader(AddressListener.class);
        List<AddressListener> supportedListeners = addressListenerExtensionLoader.getActivateExtension(this.getUrl(), (String[])null);
        if (supportedListeners != null && !supportedListeners.isEmpty()) {
            for (AddressListener addressListener : supportedListeners) {
                providerURLs = addressListener.notify(providerURLs, this.getConsumerUrl(), this);
            }
        }
        this.refreshOverrideAndInvoker(providerURLs);
    }

    @Override
    public boolean isServiceDiscovery() {
        return false;
    }

    private String judgeCategory(URL url) {
        if (UrlUtils.isConfigurator(url)) {
            return "configurators";
        }
        if (UrlUtils.isRoute(url)) {
            return "routers";
        }
        if (UrlUtils.isProvider(url)) {
            return "providers";
        }
        return "";
    }

    @Override
    protected synchronized void refreshOverrideAndInvoker(List<URL> urls) {
        this.directoryUrl = this.overrideWithConfigurator(this.getOriginalConsumerUrl());
        this.refreshInvoker(urls);
    }

    private void refreshInvoker(List<URL> invokerUrls) {
        Assert.notNull(invokerUrls, "invokerUrls should not be null");
        if (invokerUrls.size() == 1 && invokerUrls.get(0) != null && "empty".equals(invokerUrls.get(0).getProtocol())) {
            this.refreshRouter(BitList.emptyList(), () -> {
                this.forbidden = true;
            });
            this.destroyAllInvokers();
        } else {
            Map<URL, Invoker<T>> newUrlInvokerMap;
            this.forbidden = false;
            if (invokerUrls == Collections.emptyList()) {
                invokerUrls = new ArrayList<URL>();
            }
            Set<URL> localCachedInvokerUrls = this.cachedInvokerUrls;
            if (invokerUrls.isEmpty()) {
                if (CollectionUtils.isNotEmpty(localCachedInvokerUrls)) {
                    logger.warn("1-4", "configuration ", "", "Service" + this.serviceKey + " received empty address list with no EMPTY protocol set, trigger empty protection.");
                    invokerUrls.addAll(localCachedInvokerUrls);
                }
            } else {
                localCachedInvokerUrls = new HashSet<URL>();
                localCachedInvokerUrls.addAll(invokerUrls);
                this.cachedInvokerUrls = localCachedInvokerUrls;
            }
            if (invokerUrls.isEmpty()) {
                return;
            }
            Map<URL, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
            LinkedHashMap<URL, Invoker<T>> oldUrlInvokerMap = null;
            if (localUrlInvokerMap != null) {
                oldUrlInvokerMap = new LinkedHashMap<URL, Invoker<T>>(Math.round(1.0f + (float)localUrlInvokerMap.size() / 0.75f));
                localUrlInvokerMap.forEach(oldUrlInvokerMap::put);
            }
            if (CollectionUtils.isEmptyMap(newUrlInvokerMap = this.toInvokers(oldUrlInvokerMap, invokerUrls))) {
                logger.error("3-1", "inconsistency between the client protocol and the protocol of the server", "", "urls to invokers error", new IllegalStateException("urls to invokers error. invokerUrls.size :" + invokerUrls.size() + ", invoker.size :0. urls :" + invokerUrls.toString()));
                return;
            }
            List<Invoker<T>> newInvokers = Collections.unmodifiableList(new ArrayList<Invoker<T>>(newUrlInvokerMap.values()));
            BitList<Invoker<T>> finalInvokers = this.multiGroup ? new BitList<Invoker<T>>(this.toMergeInvokerList(newInvokers)) : new BitList<Invoker<T>>(newInvokers);
            this.refreshRouter(finalInvokers.clone(), () -> this.setInvokers(finalInvokers));
            this.urlInvokerMap = newUrlInvokerMap;
            try {
                this.destroyUnusedInvokers(oldUrlInvokerMap, newUrlInvokerMap);
            }
            catch (Exception e) {
                logger.warn("1-15", "", "", "destroyUnusedInvokers error. ", e);
            }
            this.invokersChanged();
        }
        logger.info("Received invokers changed event from registry. Registry type: interface. Service Key: " + this.getConsumerUrl().getServiceKey() + ". Urls Size : " + invokerUrls.size() + ". Invokers Size : " + this.getInvokers().size() + ". Available Size: " + this.getValidInvokers().size() + ". Available Invokers : " + this.joinValidInvokerAddresses());
    }

    private List<Invoker<T>> toMergeInvokerList(List<Invoker<T>> invokers) {
        ArrayList<Invoker<T>> mergedInvokers = new ArrayList();
        HashMap<String, List> groupMap = new HashMap<String, List>();
        for (Invoker<T> invoker : invokers) {
            String group = invoker.getUrl().getGroup("");
            groupMap.computeIfAbsent(group, k -> new ArrayList());
            ((List)groupMap.get(group)).add(invoker);
        }
        if (groupMap.size() == 1) {
            mergedInvokers.addAll((Collection)groupMap.values().iterator().next());
        } else if (groupMap.size() > 1) {
            for (List groupList : groupMap.values()) {
                StaticDirectory staticDirectory = new StaticDirectory(groupList);
                staticDirectory.buildRouterChain();
                mergedInvokers.add(this.cluster.join(staticDirectory, false));
            }
        } else {
            mergedInvokers = invokers;
        }
        return mergedInvokers;
    }

    private Optional<List<Router>> toRouters(List<URL> urls) {
        if (urls == null || urls.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<Router> routers = new ArrayList<Router>();
        for (URL url : urls) {
            if ("empty".equals(url.getProtocol())) continue;
            String routerType = url.getParameter("router");
            if (routerType != null && routerType.length() > 0) {
                url = url.setProtocol(routerType);
            }
            try {
                Router router = this.routerFactory.getRouter(url);
                if (routers.contains(router)) continue;
                routers.add(router);
            }
            catch (Throwable t) {
                logger.error("3-1", "", "", "convert router url to router error, url:" + url, t);
            }
        }
        return Optional.of(routers);
    }

    private Map<URL, Invoker<T>> toInvokers(Map<URL, Invoker<T>> oldUrlInvokerMap, List<URL> urls) {
        ConcurrentHashMap<URL, Invoker<T>> newUrlInvokerMap = new ConcurrentHashMap<URL, Invoker<T>>(urls == null ? 1 : (int)((float)urls.size() / 0.75f + 1.0f));
        if (urls == null || urls.isEmpty()) {
            return newUrlInvokerMap;
        }
        String queryProtocols = (String)this.queryMap.get("protocol");
        for (URL providerUrl : urls) {
            Invoker<T> invoker;
            if (!this.checkProtocolValid(queryProtocols, providerUrl)) continue;
            URL url = this.mergeUrl(providerUrl);
            Invoker<T> invoker2 = invoker = oldUrlInvokerMap == null ? null : oldUrlInvokerMap.remove(url);
            if (invoker == null) {
                try {
                    boolean enabled = true;
                    enabled = url.hasParameter("disabled") ? !url.getParameter("disabled", false) : url.getParameter("enabled", true);
                    if (enabled) {
                        invoker = this.protocol.refer(this.serviceType, url);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof RpcException && t.getMessage().contains("serialization optimizer")) {
                        logger.error("4-2", "typo in optimizer class", "", "Failed to refer invoker for interface:" + this.serviceType + ",url:(" + url + ")" + t.getMessage(), t);
                    }
                    logger.error("4-3", "", "", "Failed to refer invoker for interface:" + this.serviceType + ",url:(" + url + ")" + t.getMessage(), t);
                }
                if (invoker == null) continue;
                newUrlInvokerMap.put(url, invoker);
                continue;
            }
            newUrlInvokerMap.put(url, invoker);
        }
        return newUrlInvokerMap;
    }

    private boolean checkProtocolValid(String queryProtocols, URL providerUrl) {
        if (queryProtocols != null && queryProtocols.length() > 0) {
            String[] acceptProtocols;
            boolean accept = false;
            for (String acceptProtocol : acceptProtocols = queryProtocols.split(",")) {
                if (!providerUrl.getProtocol().equals(acceptProtocol)) continue;
                accept = true;
                break;
            }
            if (!accept) {
                return false;
            }
        }
        if ("empty".equals(providerUrl.getProtocol())) {
            return false;
        }
        if (!this.getUrl().getOrDefaultFrameworkModel().getExtensionLoader(Protocol.class).hasExtension(providerUrl.getProtocol())) {
            logger.error("4-1", "protocol extension does not installed", "", "Unsupported protocol.", new IllegalStateException("Unsupported protocol " + providerUrl.getProtocol() + " in notified url: " + providerUrl + " from registry " + this.getUrl().getAddress() + " to consumer " + NetUtils.getLocalHost() + ", supported protocol: " + this.getUrl().getOrDefaultFrameworkModel().getExtensionLoader(Protocol.class).getSupportedExtensions()));
            return false;
        }
        return true;
    }

    private URL mergeUrl(URL providerUrl) {
        String path;
        if (providerUrl instanceof ServiceAddressURL) {
            providerUrl = this.overrideWithConfigurator(providerUrl);
        } else {
            providerUrl = this.moduleModel.getApplicationModel().getBeanFactory().getBean(ClusterUtils.class).mergeUrl(providerUrl, this.queryMap);
            providerUrl = this.overrideWithConfigurator(providerUrl);
            providerUrl = providerUrl.addParameter("check", String.valueOf(false));
        }
        if (providerUrl.hasParameter("mock") || providerUrl.getAnyMethodParameter("mock") != null) {
            providerUrl = providerUrl.removeParameter("dubbo.tag");
        }
        if ((providerUrl.getPath() == null || providerUrl.getPath().length() == 0) && "dubbo".equals(providerUrl.getProtocol()) && (path = this.directoryUrl.getServiceInterface()) != null) {
            int i = path.indexOf(47);
            if (i >= 0) {
                path = path.substring(i + 1);
            }
            if ((i = path.lastIndexOf(58)) >= 0) {
                path = path.substring(0, i);
            }
            providerUrl = providerUrl.setPath(path);
        }
        return providerUrl;
    }

    protected URL overrideWithConfigurator(URL providerUrl) {
        providerUrl = this.overrideWithConfigurators(this.configurators, providerUrl);
        providerUrl = this.overrideWithConfigurators(this.consumerConfigurationListener.getConfigurators(), providerUrl);
        if (this.referenceConfigurationListener != null) {
            providerUrl = this.overrideWithConfigurators(this.referenceConfigurationListener.getConfigurators(), providerUrl);
        }
        return providerUrl;
    }

    private URL overrideWithConfigurators(List<Configurator> configurators, URL url) {
        if (CollectionUtils.isNotEmpty(configurators)) {
            if (url instanceof DubboServiceAddressURL) {
                DubboServiceAddressURL interfaceAddressURL = (DubboServiceAddressURL)url;
                URL overriddenURL = interfaceAddressURL.getOverrideURL();
                if (overriddenURL == null) {
                    String appName = interfaceAddressURL.getApplication();
                    String side = interfaceAddressURL.getSide();
                    overriddenURL = URLBuilder.from(interfaceAddressURL).clearParameters().addParameter("application", appName).addParameter("side", side).build();
                }
                for (Configurator configurator : configurators) {
                    overriddenURL = configurator.configure(overriddenURL);
                }
                url = new DubboServiceAddressURL(interfaceAddressURL.getUrlAddress(), interfaceAddressURL.getUrlParam(), interfaceAddressURL.getConsumerURL(), (ServiceConfigURL)overriddenURL);
            } else {
                for (Configurator configurator : configurators) {
                    url = configurator.configure(url);
                }
            }
        }
        return url;
    }

    @Override
    protected void destroyAllInvokers() {
        Map<URL, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        if (!CollectionUtils.isEmptyMap(localUrlInvokerMap)) {
            for (Invoker<T> invoker : new ArrayList<Invoker<T>>(localUrlInvokerMap.values())) {
                try {
                    invoker.destroy();
                }
                catch (Throwable t) {
                    logger.warn("1-15", "", "", "Failed to destroy service " + this.serviceKey + " to provider " + invoker.getUrl(), t);
                }
            }
            localUrlInvokerMap.clear();
        }
        this.urlInvokerMap = null;
        this.cachedInvokerUrls = null;
        this.destroyInvokers();
    }

    private void destroyUnusedInvokers(Map<URL, Invoker<T>> oldUrlInvokerMap, Map<URL, Invoker<T>> newUrlInvokerMap) {
        if (CollectionUtils.isEmptyMap(newUrlInvokerMap)) {
            this.destroyAllInvokers();
            return;
        }
        if (CollectionUtils.isEmptyMap(oldUrlInvokerMap)) {
            return;
        }
        for (Map.Entry<URL, Invoker<T>> entry : oldUrlInvokerMap.entrySet()) {
            Invoker<T> invoker = entry.getValue();
            if (invoker == null) continue;
            try {
                invoker.destroy();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("destroy invoker[" + invoker.getUrl() + "] success. ");
            }
            catch (Exception e) {
                logger.warn("1-15", "", "", "destroy invoker[" + invoker.getUrl() + "] failed. " + e.getMessage(), e);
            }
        }
        logger.info("New url total size, " + newUrlInvokerMap.size() + ", destroyed total size " + oldUrlInvokerMap.size());
    }

    public Map<URL, Invoker<T>> getUrlInvokerMap() {
        return this.urlInvokerMap;
    }

    private boolean isValidCategory(URL url) {
        String category = url.getCategory("providers");
        if ("routers".equals(category) || "route".equals(url.getProtocol()) || "providers".equals(category) || "configurators".equals(category) || "dynamicconfigurators".equals(category) || "appdynamicconfigurators".equals(category)) {
            return true;
        }
        logger.warn("1-16", "", "", "Unsupported category " + category + " in notified url: " + url + " from registry " + this.getUrl().getAddress() + " to consumer " + NetUtils.getLocalHost());
        return false;
    }

    private boolean isNotCompatibleFor26x(URL url) {
        return StringUtils.isEmpty(url.getParameter("compatible_config"));
    }

    private static class ConsumerConfigurationListener
    extends AbstractConfiguratorListener {
        List<RegistryDirectory> listeners = new ArrayList<RegistryDirectory>();

        ConsumerConfigurationListener(ModuleModel moduleModel) {
            super(moduleModel);
            this.initWith(moduleModel.getApplicationModel().getApplicationName() + ".configurators");
        }

        void addNotifyListener(RegistryDirectory listener) {
            this.listeners.add(listener);
        }

        void removeNotifyListener(RegistryDirectory listener) {
            this.listeners.remove(listener);
        }

        @Override
        protected void notifyOverrides() {
            this.listeners.forEach(listener -> listener.refreshOverrideAndInvoker(Collections.emptyList()));
        }
    }

    private static class ReferenceConfigurationListener
    extends AbstractConfiguratorListener {
        private RegistryDirectory directory;
        private URL url;

        ReferenceConfigurationListener(ModuleModel moduleModel, RegistryDirectory directory, URL url) {
            super(moduleModel);
            this.directory = directory;
            this.url = url;
            this.initWith(DynamicConfiguration.getRuleKey(url) + ".configurators");
        }

        void stop() {
            this.stopListen(DynamicConfiguration.getRuleKey(this.url) + ".configurators");
        }

        @Override
        protected void notifyOverrides() {
            this.directory.refreshOverrideAndInvoker(Collections.emptyList());
        }
    }
}

