/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.pu;

import org.apache.dubbo.qos.pu.QosHTTP1Detector;
import org.apache.dubbo.qos.pu.TelnetDetector;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class QosDetector
implements ProtocolDetector {
    private final QosHTTP1Detector qosHTTP1Detector = new QosHTTP1Detector();
    private final TelnetDetector telnetDetector;
    private boolean QosEnableFlag = true;

    public void setQosEnableFlag(boolean qosEnableFlag) {
        this.QosEnableFlag = qosEnableFlag;
    }

    public QosDetector(FrameworkModel frameworkModel) {
        this.telnetDetector = new TelnetDetector(frameworkModel);
    }

    @Override
    public ProtocolDetector.Result detect(ChannelBuffer in) {
        if (!this.QosEnableFlag) {
            return ProtocolDetector.Result.UNRECOGNIZED;
        }
        ProtocolDetector.Result h1Res = this.qosHTTP1Detector.detect(in);
        if (h1Res.equals((Object)ProtocolDetector.Result.RECOGNIZED)) {
            return h1Res;
        }
        ProtocolDetector.Result telRes = this.telnetDetector.detect(in);
        if (telRes.equals((Object)ProtocolDetector.Result.RECOGNIZED)) {
            return telRes;
        }
        if (h1Res.equals((Object)ProtocolDetector.Result.NEED_MORE_DATA) || telRes.equals((Object)ProtocolDetector.Result.NEED_MORE_DATA)) {
            return ProtocolDetector.Result.NEED_MORE_DATA;
        }
        return ProtocolDetector.Result.UNRECOGNIZED;
    }
}

