/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.prometheus;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.metrics.report.MetricsReporter;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="metrics", summary="reuse qos report")
public class PrometheusMetricsReporterCmd
implements BaseCommand {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(PrometheusMetricsReporterCmd.class);
    public FrameworkModel frameworkModel;

    public PrometheusMetricsReporterCmd(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        List<ApplicationModel> models = this.frameworkModel.getApplicationModels();
        String result = "There is no application with data";
        result = this.notSpecifyApplication(args) ? this.useFirst(models, result) : this.specifyApplication(args[0], models);
        return result;
    }

    private boolean notSpecifyApplication(String[] args) {
        return args == null || args.length == 0;
    }

    private String useFirst(List<ApplicationModel> models, String result) {
        for (ApplicationModel model : models) {
            String current = this.getResponseByApplication(model);
            if (PrometheusMetricsReporterCmd.getLineNumber(current) <= 1L) continue;
            result = current;
            break;
        }
        return result;
    }

    private String specifyApplication(String appName, List<ApplicationModel> models) {
        if ("application_all".equals(appName)) {
            return this.allApplication(models);
        }
        return this.specifySingleApplication(appName, models);
    }

    private String specifySingleApplication(String appName, List<ApplicationModel> models) {
        Optional<ApplicationModel> modelOptional = models.stream().filter(applicationModel -> appName.equals(applicationModel.getApplicationName())).findFirst();
        if (modelOptional.isPresent()) {
            return this.getResponseByApplication(modelOptional.get());
        }
        return "Not exist application: " + appName;
    }

    private String allApplication(List<ApplicationModel> models) {
        HashMap<String, String> appResultMap = new HashMap<String, String>();
        for (ApplicationModel model : models) {
            appResultMap.put(model.getApplicationName(), this.getResponseByApplication(model));
        }
        return JsonUtils.toJson(appResultMap);
    }

    @Override
    public boolean logResult() {
        return false;
    }

    private String getResponseByApplication(ApplicationModel applicationModel) {
        String response = "MetricsReporter not init";
        MetricsReporter metricsReporter = applicationModel.getBeanFactory().getBean(MetricsReporter.class);
        if (metricsReporter != null) {
            long begin = System.currentTimeMillis();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("scrape begin");
            }
            metricsReporter.refreshData();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("scrape end,Elapsed Time\uff1a%s", System.currentTimeMillis() - begin));
            }
            response = metricsReporter.getResponse();
        }
        return response;
    }

    private static long getLineNumber(String content) {
        LineNumberReader lnr = new LineNumberReader(new CharArrayReader(content.toCharArray()));
        try {
            lnr.skip(Long.MAX_VALUE);
            lnr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lnr.getLineNumber();
    }
}

