/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.metadata.event;

import java.util.function.BiConsumer;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.listener.MetricsLifeListener;
import org.apache.dubbo.metrics.metadata.event.MetadataEvent;

public abstract class MetadataListener
implements MetricsLifeListener<MetadataEvent> {
    private final Object enumType;

    public MetadataListener(Object enumType) {
        this.enumType = enumType;
    }

    @Override
    public boolean isSupport(MetricsEvent event) {
        return event.isAvailable() && event.isAssignableFrom(this.enumType);
    }

    static <T> MetadataListener onEvent(final T enumType, final BiConsumer<MetadataEvent, T> postFunc) {
        return new MetadataListener(enumType){

            @Override
            public void onEvent(MetadataEvent event) {
                postFunc.accept(event, enumType);
            }
        };
    }

    static <T> MetadataListener onFinish(final T enumType, final BiConsumer<MetadataEvent, T> finishFunc) {
        return new MetadataListener(enumType){

            @Override
            public void onEventFinish(MetadataEvent event) {
                finishFunc.accept(event, enumType);
            }
        };
    }

    static <T> MetadataListener onError(final T enumType, final BiConsumer<MetadataEvent, T> errorFunc) {
        return new MetadataListener(enumType){

            @Override
            public void onEventError(MetadataEvent event) {
                errorFunc.accept(event, enumType);
            }
        };
    }
}

