/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.metadata.event;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.exception.MetricsNeverHappenException;
import org.apache.dubbo.metrics.metadata.collector.MetadataMetricsCollector;
import org.apache.dubbo.metrics.metadata.type.ApplicationType;
import org.apache.dubbo.metrics.metadata.type.ServiceType;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataEvent
extends TimeCounterEvent {
    private final MetadataMetricsCollector collector;
    private final Map<String, Object> attachment = new HashMap<String, Object>(8);

    public MetadataEvent(ApplicationModel applicationModel, TypeWrapper typeWrapper) {
        super(applicationModel);
        this.typeWrapper = typeWrapper;
        ScopeBeanFactory beanFactory = applicationModel.getBeanFactory();
        if (beanFactory.isDestroyed()) {
            this.collector = null;
        } else {
            this.collector = beanFactory.getBean(MetadataMetricsCollector.class);
            super.setAvailable(this.collector != null && this.collector.isCollectEnabled());
        }
    }

    public <T> T getAttachmentValue(String key) {
        if (!this.attachment.containsKey(key)) {
            throw new MetricsNeverHappenException("Attachment key [" + key + "] not found");
        }
        return (T)this.attachment.get(key);
    }

    public void putAttachment(String key, Object value) {
        this.attachment.put(key, value);
    }

    @Override
    public ApplicationModel getSource() {
        return this.source;
    }

    public MetadataMetricsCollector getCollector() {
        return this.collector;
    }

    public static MetadataEvent toPushEvent(ApplicationModel applicationModel) {
        return new MetadataEvent(applicationModel, new TypeWrapper(MetricsLevel.APP, (Object)ApplicationType.P_TOTAL, (Object)ApplicationType.P_SUCCEED, (Object)ApplicationType.P_FAILED));
    }

    public static MetadataEvent toSubscribeEvent(ApplicationModel applicationModel) {
        return new MetadataEvent(applicationModel, new TypeWrapper(MetricsLevel.APP, (Object)ApplicationType.S_TOTAL, (Object)ApplicationType.S_SUCCEED, (Object)ApplicationType.S_FAILED));
    }

    public static MetadataEvent toServiceSubscribeEvent(ApplicationModel applicationModel, String serviceKey) {
        MetadataEvent metadataEvent = new MetadataEvent(applicationModel, new TypeWrapper(MetricsLevel.APP, (Object)ServiceType.S_P_TOTAL, (Object)ServiceType.S_P_SUCCEED, (Object)ServiceType.S_P_FAILED));
        metadataEvent.putAttachment("serviceKey", serviceKey);
        return metadataEvent;
    }
}

