/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.filter;

import java.util.Optional;
import org.apache.dubbo.metrics.collector.sample.MethodMetricsSampler;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

public class MethodMetricsInterceptor {
    private final MethodMetricsSampler sampler;

    public MethodMetricsInterceptor(MethodMetricsSampler sampler) {
        this.sampler = sampler;
    }

    public void beforeMethod(Invocation invocation) {
        String side = this.getSide(invocation);
        this.sampler.incOnEvent(invocation, MetricsEvent.Type.TOTAL.getNameByType(side));
        this.sampler.incOnEvent(invocation, MetricsEvent.Type.PROCESSING.getNameByType(side));
        invocation.put("metric_filter_start_time", System.currentTimeMillis());
    }

    private String getSide(Invocation invocation) {
        Optional<Invoker<?>> invoker = Optional.ofNullable(invocation.getInvoker());
        String side = invoker.isPresent() ? invoker.get().getUrl().getSide() : "provider";
        return side;
    }

    public void afterMethod(Invocation invocation, Result result) {
        if (result.hasException()) {
            this.handleMethodException(invocation, result.getException());
        } else {
            this.sampler.incOnEvent(invocation, MetricsEvent.Type.SUCCEED.getNameByType(this.getSide(invocation)));
            this.onCompleted(invocation);
        }
    }

    public void handleMethodException(Invocation invocation, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        String side = this.getSide(invocation);
        if (throwable instanceof RpcException) {
            RpcException e = (RpcException)throwable;
            MetricsEvent.Type eventType = MetricsEvent.Type.UNKNOWN_FAILED;
            if (e.isTimeout()) {
                eventType = MetricsEvent.Type.REQUEST_TIMEOUT;
            }
            if (e.isLimitExceed()) {
                eventType = MetricsEvent.Type.REQUEST_LIMIT;
            }
            if (e.isBiz()) {
                eventType = MetricsEvent.Type.BUSINESS_FAILED;
            }
            if (e.isSerialization()) {
                eventType = MetricsEvent.Type.CODEC_EXCEPTION;
            }
            if (e.isNetwork()) {
                eventType = MetricsEvent.Type.NETWORK_EXCEPTION;
            }
            this.sampler.incOnEvent(invocation, eventType.getNameByType(side));
        }
        this.onCompleted(invocation);
        this.sampler.incOnEvent(invocation, MetricsEvent.Type.TOTAL_FAILED.getNameByType(side));
    }

    private void rtTime(Invocation invocation) {
        Long endTime = System.currentTimeMillis();
        Long beginTime = (Long)invocation.get("metric_filter_start_time");
        Long rt = endTime - beginTime;
        this.sampler.addRT(invocation, rt);
    }

    private void onCompleted(Invocation invocation) {
        this.rtTime(invocation);
        this.sampler.dec(invocation, MetricsEvent.Type.PROCESSING.getNameByType(this.getSide(invocation)));
    }
}

