/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.metrics.data.ApplicationStatComposite;
import org.apache.dubbo.metrics.data.RtStatComposite;
import org.apache.dubbo.metrics.data.ServiceStatComposite;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.report.MetricsExport;

public abstract class BaseStatComposite
implements MetricsExport {
    private final ApplicationStatComposite applicationStatComposite = new ApplicationStatComposite();
    private final ServiceStatComposite serviceStatComposite = new ServiceStatComposite();
    private final RtStatComposite rtStatComposite = new RtStatComposite();

    public BaseStatComposite() {
        this.init(this.applicationStatComposite, this.serviceStatComposite, this.rtStatComposite);
    }

    protected abstract void init(ApplicationStatComposite var1, ServiceStatComposite var2, RtStatComposite var3);

    public void calcApplicationRt(String applicationName, String registryOpType, Long responseTime) {
        this.rtStatComposite.calcApplicationRt(applicationName, registryOpType, responseTime);
    }

    public void calcServiceKeyRt(String applicationName, String serviceKey, String registryOpType, Long responseTime) {
        this.rtStatComposite.calcServiceKeyRt(applicationName, serviceKey, registryOpType, responseTime);
    }

    public void setServiceKey(MetricsKey metricsKey, String applicationName, String serviceKey, int num) {
        this.serviceStatComposite.setServiceKey(metricsKey, applicationName, serviceKey, num);
    }

    public void setApplicationKey(MetricsKey metricsKey, String applicationName, int num) {
        this.applicationStatComposite.setApplicationKey(metricsKey, applicationName, num);
    }

    public void incrementApp(MetricsKey metricsKey, String applicationName, int size) {
        this.applicationStatComposite.incrementSize(metricsKey, applicationName, size);
    }

    public void incrementServiceKey(MetricsKey metricsKey, String applicationName, String attServiceKey, int size) {
        this.serviceStatComposite.incrementServiceKey(metricsKey, applicationName, attServiceKey, size);
    }

    @Override
    public List<GaugeMetricSample> export(MetricsCategory category) {
        ArrayList<GaugeMetricSample> list = new ArrayList<GaugeMetricSample>();
        list.addAll(this.applicationStatComposite.export(category));
        list.addAll(this.rtStatComposite.export(category));
        list.addAll(this.serviceStatComposite.export(category));
        return list;
    }

    public ApplicationStatComposite getApplicationStatComposite() {
        return this.applicationStatComposite;
    }

    public RtStatComposite getRtStatComposite() {
        return this.rtStatComposite;
    }
}

