/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.HistogramConfig;
import org.apache.dubbo.metrics.MetricsGlobalRegistry;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.RTEvent;
import org.apache.dubbo.metrics.listener.MetricsListener;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.register.HistogramMetricRegister;
import org.apache.dubbo.metrics.sample.HistogramMetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class HistogramMetricsCollector
implements MetricsListener {
    private final ConcurrentHashMap<MethodMetric, Timer> rt = new ConcurrentHashMap();
    private HistogramMetricRegister metricRegister;
    private final ApplicationModel applicationModel;
    private static final Integer[] DEFAULT_BUCKETS_MS = new Integer[]{100, 300, 500, 1000, 3000, 5000, 10000};

    public HistogramMetricsCollector(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        ConfigManager configManager = applicationModel.getApplicationConfigManager();
        MetricsConfig config = configManager.getMetrics().orElse(null);
        if (config != null && config.getHistogram() != null && Boolean.TRUE.equals(config.getHistogram().getEnabled())) {
            this.registerListener();
            HistogramConfig histogram = config.getHistogram();
            if (!Boolean.TRUE.equals(histogram.getEnabledPercentiles()) && histogram.getBucketsMs() == null) {
                histogram.setBucketsMs(DEFAULT_BUCKETS_MS);
            }
            this.metricRegister = new HistogramMetricRegister((MeterRegistry)MetricsGlobalRegistry.getCompositeRegistry(), histogram);
        }
    }

    private void registerListener() {
        this.applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class).addListener(this);
    }

    public void onEvent(MetricsEvent event) {
        if (event instanceof RTEvent) {
            this.onRTEvent((RTEvent)event);
        }
    }

    private void onRTEvent(RTEvent event) {
        if (this.metricRegister != null) {
            MethodMetric metric = (MethodMetric)event.getMetric();
            Long responseTime = event.getRt();
            HistogramMetricSample sample = new HistogramMetricSample(MetricsKey.METRIC_RT_HISTOGRAM.getNameByType(metric.getSide()), MetricsKey.METRIC_RT_HISTOGRAM.getDescription(), metric.getTags(), MetricsCategory.RT);
            Timer timer = ConcurrentHashMapUtils.computeIfAbsent(this.rt, metric, k -> this.metricRegister.register(sample));
            timer.record(responseTime.longValue(), TimeUnit.MILLISECONDS);
        }
    }
}

