/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.metrics.collector.MetricsCollector;
import org.apache.dubbo.metrics.model.ConfigCenterMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigCenterMetricsCollector
implements MetricsCollector {
    private boolean collectEnabled = true;
    private final ApplicationModel applicationModel;
    private final Map<ConfigCenterMetric, AtomicLong> updatedMetrics = new ConcurrentHashMap<ConfigCenterMetric, AtomicLong>();

    public ConfigCenterMetricsCollector(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        if ("false".equals(System.getProperty("dubbo.metrics.configcenter.enable"))) {
            this.collectEnabled = false;
        }
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        if (collectEnabled != null) {
            this.collectEnabled = collectEnabled;
        }
    }

    @Override
    public boolean isCollectEnabled() {
        return this.collectEnabled;
    }

    public void increase4Initialized(String key, String group, String protocol, String applicationName, int count) {
        if (!this.isCollectEnabled()) {
            return;
        }
        if (count <= 0) {
            return;
        }
        ConfigCenterMetric metric = new ConfigCenterMetric(applicationName, key, group, protocol, ConfigChangeType.ADDED.name());
        AtomicLong aLong = this.updatedMetrics.computeIfAbsent(metric, k -> new AtomicLong(0L));
        aLong.addAndGet(count);
    }

    public void increaseUpdated(String protocol, String applicationName, ConfigChangedEvent event) {
        if (!this.isCollectEnabled()) {
            return;
        }
        ConfigCenterMetric metric = new ConfigCenterMetric(applicationName, event.getKey(), event.getGroup(), protocol, event.getChangeType().name());
        AtomicLong count = this.updatedMetrics.computeIfAbsent(metric, k -> new AtomicLong(0L));
        count.incrementAndGet();
    }

    @Override
    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        if (!this.isCollectEnabled()) {
            return list;
        }
        this.collect(list);
        return list;
    }

    private void collect(List<MetricSample> list) {
        this.updatedMetrics.forEach((k, v) -> list.add(new GaugeMetricSample<AtomicLong>(MetricsKey.CONFIGCENTER_METRIC_TOTAL, k.getTags(), MetricsCategory.CONFIGCENTER, (AtomicLong)v, AtomicLong::get)));
    }
}

