/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.ReferenceCache;
import org.apache.dubbo.common.deploy.ApplicationDeployer;
import org.apache.dubbo.common.deploy.DeployListenerAdapter;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.TracingConfig;
import org.apache.dubbo.config.bootstrap.BootstrapTakeoverMode;
import org.apache.dubbo.config.bootstrap.DubboBootstrapStartStopListener;
import org.apache.dubbo.config.bootstrap.builders.ApplicationBuilder;
import org.apache.dubbo.config.bootstrap.builders.ConfigCenterBuilder;
import org.apache.dubbo.config.bootstrap.builders.ConsumerBuilder;
import org.apache.dubbo.config.bootstrap.builders.MetadataReportBuilder;
import org.apache.dubbo.config.bootstrap.builders.ProtocolBuilder;
import org.apache.dubbo.config.bootstrap.builders.ProviderBuilder;
import org.apache.dubbo.config.bootstrap.builders.ReferenceBuilder;
import org.apache.dubbo.config.bootstrap.builders.RegistryBuilder;
import org.apache.dubbo.config.bootstrap.builders.ServiceBuilder;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;

public final class DubboBootstrap {
    private static final String NAME = DubboBootstrap.class.getSimpleName();
    private static final Logger logger = LoggerFactory.getLogger(DubboBootstrap.class);
    private static final ConcurrentMap<ApplicationModel, DubboBootstrap> instanceMap = new ConcurrentHashMap<ApplicationModel, DubboBootstrap>();
    private static volatile DubboBootstrap instance;
    private final AtomicBoolean awaited = new AtomicBoolean(false);
    private volatile BootstrapTakeoverMode takeoverMode = BootstrapTakeoverMode.AUTO;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ExecutorRepository executorRepository;
    private final Environment environment;
    private final ApplicationModel applicationModel;
    private final ConfigManager configManager;
    private final ApplicationDeployer applicationDeployer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DubboBootstrap getInstance() {
        if (instance != null) return instance;
        Class<DubboBootstrap> clazz = DubboBootstrap.class;
        synchronized (DubboBootstrap.class) {
            if (instance != null) return instance;
            instance = DubboBootstrap.getInstance(ApplicationModel.defaultModel());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static DubboBootstrap getInstance(ApplicationModel applicationModel) {
        return ConcurrentHashMapUtils.computeIfAbsent(instanceMap, applicationModel, _k -> new DubboBootstrap(applicationModel));
    }

    public static DubboBootstrap newInstance() {
        return DubboBootstrap.getInstance(FrameworkModel.defaultModel().newApplication());
    }

    public static DubboBootstrap newInstance(FrameworkModel frameworkModel) {
        return DubboBootstrap.getInstance(frameworkModel.newApplication());
    }

    @Deprecated
    public static void reset() {
        DubboBootstrap.reset(true);
    }

    @Deprecated
    public static void reset(boolean destroy) {
        if (destroy) {
            if (instance != null) {
                instance.destroy();
                instance = null;
            }
            FrameworkModel.destroyAll();
        } else {
            instance = null;
        }
        ApplicationModel.reset();
    }

    private DubboBootstrap(final ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.configManager = applicationModel.getApplicationConfigManager();
        this.environment = applicationModel.getModelEnvironment();
        this.executorRepository = ExecutorRepository.getInstance(applicationModel);
        this.applicationDeployer = applicationModel.getDeployer();
        this.applicationDeployer.addDeployListener(new DeployListenerAdapter<ApplicationModel>(){

            @Override
            public void onStarted(ApplicationModel scopeModel) {
                DubboBootstrap.this.notifyStarted(applicationModel);
            }

            @Override
            public void onStopped(ApplicationModel scopeModel) {
                DubboBootstrap.this.notifyStopped(applicationModel);
            }

            @Override
            public void onFailure(ApplicationModel scopeModel, Throwable cause) {
                DubboBootstrap.this.notifyStopped(applicationModel);
            }
        });
        applicationModel.getBeanFactory().registerBean(this);
    }

    private void notifyStarted(ApplicationModel applicationModel) {
        ExtensionLoader<DubboBootstrapStartStopListener> exts = applicationModel.getExtensionLoader(DubboBootstrapStartStopListener.class);
        exts.getSupportedExtensionInstances().forEach(ext -> ext.onStart(this));
    }

    private void notifyStopped(ApplicationModel applicationModel) {
        ExtensionLoader<DubboBootstrapStartStopListener> exts = applicationModel.getExtensionLoader(DubboBootstrapStartStopListener.class);
        exts.getSupportedExtensionInstances().forEach(ext -> ext.onStop(this));
        this.executeMutually(() -> {
            this.awaited.set(true);
            this.condition.signalAll();
        });
        instanceMap.remove(applicationModel);
    }

    public void initialize() {
        this.applicationDeployer.initialize();
    }

    public DubboBootstrap start() {
        this.start(true);
        return this;
    }

    public DubboBootstrap start(boolean wait) {
        Future future = this.applicationDeployer.start();
        if (wait) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new IllegalStateException("await dubbo application start finish failure", e);
            }
        }
        return this;
    }

    public Future asyncStart() {
        return this.applicationDeployer.start();
    }

    public DubboBootstrap stop() throws IllegalStateException {
        this.destroy();
        return this;
    }

    public void destroy() {
        this.applicationModel.destroy();
    }

    public boolean isInitialized() {
        return this.applicationDeployer.isInitialized();
    }

    public boolean isPending() {
        return this.applicationDeployer.isPending();
    }

    public boolean isRunning() {
        return this.applicationDeployer.isRunning();
    }

    public boolean isStarting() {
        return this.applicationDeployer.isStarting();
    }

    public boolean isStarted() {
        return this.applicationDeployer.isStarted();
    }

    public boolean isStopping() {
        return this.applicationDeployer.isStopping();
    }

    public boolean isStopped() {
        return this.applicationDeployer.isStopped();
    }

    public DubboBootstrap await() {
        if (!this.awaited.get() && !this.isStopped()) {
            this.executeMutually(() -> {
                while (!this.awaited.get()) {
                    if (logger.isInfoEnabled()) {
                        logger.info(NAME + " awaiting ...");
                    }
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
        return this;
    }

    public ReferenceCache getCache() {
        return this.applicationDeployer.getReferenceCache();
    }

    private void executeMutually(Runnable runnable) {
        try {
            this.lock.lock();
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ApplicationConfig getApplication() {
        return this.configManager.getApplicationOrElseThrow();
    }

    public void setTakeoverMode(BootstrapTakeoverMode takeoverMode) {
        this.takeoverMode = takeoverMode;
    }

    public BootstrapTakeoverMode getTakeoverMode() {
        return this.takeoverMode;
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DubboBootstrap metadataReport(Consumer<MetadataReportBuilder> consumerBuilder) {
        return this.metadataReport(null, consumerBuilder);
    }

    public DubboBootstrap metadataReport(String id, Consumer<MetadataReportBuilder> consumerBuilder) {
        MetadataReportBuilder metadataReportBuilder = this.createMetadataReportBuilder(id);
        consumerBuilder.accept(metadataReportBuilder);
        return this;
    }

    public DubboBootstrap metadataReport(MetadataReportConfig metadataReportConfig) {
        this.configManager.addMetadataReport(metadataReportConfig);
        return this;
    }

    public DubboBootstrap metadataReports(List<MetadataReportConfig> metadataReportConfigs) {
        if (CollectionUtils.isEmpty(metadataReportConfigs)) {
            return this;
        }
        this.configManager.addMetadataReports(metadataReportConfigs);
        return this;
    }

    public DubboBootstrap application(String name) {
        return this.application(name, builder -> {});
    }

    public DubboBootstrap application(String name, Consumer<ApplicationBuilder> consumerBuilder) {
        ApplicationBuilder builder = this.createApplicationBuilder(name);
        consumerBuilder.accept(builder);
        return this.application(builder.build());
    }

    public DubboBootstrap application(ApplicationConfig applicationConfig) {
        applicationConfig.setScopeModel(this.applicationModel);
        this.configManager.setApplication(applicationConfig);
        return this;
    }

    public DubboBootstrap registry(Consumer<RegistryBuilder> consumerBuilder) {
        return this.registry(null, consumerBuilder);
    }

    public DubboBootstrap registry(String id, Consumer<RegistryBuilder> consumerBuilder) {
        RegistryBuilder builder = this.createRegistryBuilder(id);
        consumerBuilder.accept(builder);
        return this.registry(builder.build());
    }

    public DubboBootstrap registry(RegistryConfig registryConfig) {
        registryConfig.setScopeModel(this.applicationModel);
        this.configManager.addRegistry(registryConfig);
        return this;
    }

    public DubboBootstrap registries(List<RegistryConfig> registryConfigs) {
        if (CollectionUtils.isEmpty(registryConfigs)) {
            return this;
        }
        registryConfigs.forEach(this::registry);
        return this;
    }

    public DubboBootstrap protocol(Consumer<ProtocolBuilder> consumerBuilder) {
        return this.protocol(null, consumerBuilder);
    }

    public DubboBootstrap protocol(String id, Consumer<ProtocolBuilder> consumerBuilder) {
        ProtocolBuilder builder = this.createProtocolBuilder(id);
        consumerBuilder.accept(builder);
        return this.protocol(builder.build());
    }

    public DubboBootstrap protocol(ProtocolConfig protocolConfig) {
        return this.protocols(Collections.singletonList(protocolConfig));
    }

    public DubboBootstrap protocols(List<ProtocolConfig> protocolConfigs) {
        if (CollectionUtils.isEmpty(protocolConfigs)) {
            return this;
        }
        for (ProtocolConfig protocolConfig : protocolConfigs) {
            protocolConfig.setScopeModel(this.applicationModel);
            this.configManager.addProtocol(protocolConfig);
        }
        return this;
    }

    public <S> DubboBootstrap service(Consumer<ServiceBuilder<S>> consumerBuilder) {
        return this.service(null, consumerBuilder);
    }

    public <S> DubboBootstrap service(String id, Consumer<ServiceBuilder<S>> consumerBuilder) {
        return this.service(this.createServiceConfig(id, consumerBuilder));
    }

    private <S> ServiceConfig createServiceConfig(String id, Consumer<ServiceBuilder<S>> consumerBuilder) {
        ServiceBuilder builder = this.createServiceBuilder(id);
        consumerBuilder.accept(builder);
        AbstractConfig serviceConfig = builder.build();
        return serviceConfig;
    }

    public DubboBootstrap services(List<ServiceConfig> serviceConfigs) {
        if (CollectionUtils.isEmpty(serviceConfigs)) {
            return this;
        }
        for (ServiceConfig serviceConfig : serviceConfigs) {
            this.service(serviceConfig);
        }
        return this;
    }

    public DubboBootstrap service(ServiceConfig<?> serviceConfig) {
        this.service(serviceConfig, this.applicationModel.getDefaultModule());
        return this;
    }

    public DubboBootstrap service(ServiceConfig<?> serviceConfig, ModuleModel moduleModel) {
        serviceConfig.setScopeModel(moduleModel);
        moduleModel.getConfigManager().addService(serviceConfig);
        return this;
    }

    public <S> DubboBootstrap reference(Consumer<ReferenceBuilder<S>> consumerBuilder) {
        return this.reference(null, consumerBuilder);
    }

    public <S> DubboBootstrap reference(String id, Consumer<ReferenceBuilder<S>> consumerBuilder) {
        return this.reference(this.createReferenceConfig(id, consumerBuilder));
    }

    private <S> ReferenceConfig createReferenceConfig(String id, Consumer<ReferenceBuilder<S>> consumerBuilder) {
        ReferenceBuilder builder = this.createReferenceBuilder(id);
        consumerBuilder.accept(builder);
        AbstractConfig referenceConfig = builder.build();
        return referenceConfig;
    }

    public DubboBootstrap references(List<ReferenceConfig> referenceConfigs) {
        if (CollectionUtils.isEmpty(referenceConfigs)) {
            return this;
        }
        for (ReferenceConfig referenceConfig : referenceConfigs) {
            this.reference(referenceConfig);
        }
        return this;
    }

    public DubboBootstrap reference(ReferenceConfig<?> referenceConfig) {
        return this.reference(referenceConfig, this.applicationModel.getDefaultModule());
    }

    public DubboBootstrap reference(ReferenceConfig<?> referenceConfig, ModuleModel moduleModel) {
        referenceConfig.setScopeModel(moduleModel);
        moduleModel.getConfigManager().addReference(referenceConfig);
        return this;
    }

    public DubboBootstrap provider(Consumer<ProviderBuilder> builderConsumer) {
        this.provider(null, builderConsumer);
        return this;
    }

    public DubboBootstrap provider(String id, Consumer<ProviderBuilder> builderConsumer) {
        this.provider(this.createProviderConfig(id, builderConsumer));
        return this;
    }

    private ProviderConfig createProviderConfig(String id, Consumer<ProviderBuilder> builderConsumer) {
        ProviderBuilder builder = this.createProviderBuilder(id);
        builderConsumer.accept(builder);
        ProviderConfig providerConfig = builder.build();
        return providerConfig;
    }

    public DubboBootstrap provider(ProviderConfig providerConfig) {
        return this.provider(providerConfig, this.applicationModel.getDefaultModule());
    }

    public DubboBootstrap providers(List<ProviderConfig> providerConfigs) {
        for (ProviderConfig providerConfig : providerConfigs) {
            this.provider(providerConfig, this.applicationModel.getDefaultModule());
        }
        return this;
    }

    public DubboBootstrap provider(ProviderConfig providerConfig, ModuleModel moduleModel) {
        providerConfig.setScopeModel(moduleModel);
        moduleModel.getConfigManager().addProvider(providerConfig);
        return this;
    }

    public DubboBootstrap consumer(Consumer<ConsumerBuilder> builderConsumer) {
        return this.consumer(null, builderConsumer);
    }

    public DubboBootstrap consumer(String id, Consumer<ConsumerBuilder> builderConsumer) {
        return this.consumer(this.createConsumerConfig(id, builderConsumer));
    }

    private ConsumerConfig createConsumerConfig(String id, Consumer<ConsumerBuilder> builderConsumer) {
        ConsumerBuilder builder = this.createConsumerBuilder(id);
        builderConsumer.accept(builder);
        ConsumerConfig consumerConfig = builder.build();
        return consumerConfig;
    }

    public DubboBootstrap consumer(ConsumerConfig consumerConfig) {
        return this.consumer(consumerConfig, this.applicationModel.getDefaultModule());
    }

    public DubboBootstrap consumers(List<ConsumerConfig> consumerConfigs) {
        for (ConsumerConfig consumerConfig : consumerConfigs) {
            this.consumer(consumerConfig, this.applicationModel.getDefaultModule());
        }
        return this;
    }

    public DubboBootstrap consumer(ConsumerConfig consumerConfig, ModuleModel moduleModel) {
        consumerConfig.setScopeModel(moduleModel);
        moduleModel.getConfigManager().addConsumer(consumerConfig);
        return this;
    }

    public DubboBootstrap module(ModuleConfig moduleConfig) {
        this.module(moduleConfig, this.applicationModel.getDefaultModule());
        return this;
    }

    public DubboBootstrap module(ModuleConfig moduleConfig, ModuleModel moduleModel) {
        moduleConfig.setScopeModel(moduleModel);
        moduleModel.getConfigManager().setModule(moduleConfig);
        return this;
    }

    public DubboBootstrap configCenter(Consumer<ConfigCenterBuilder> consumerBuilder) {
        return this.configCenter(null, consumerBuilder);
    }

    public DubboBootstrap configCenter(String id, Consumer<ConfigCenterBuilder> consumerBuilder) {
        ConfigCenterBuilder configCenterBuilder = this.createConfigCenterBuilder(id);
        consumerBuilder.accept(configCenterBuilder);
        return this;
    }

    public DubboBootstrap configCenter(ConfigCenterConfig configCenterConfig) {
        configCenterConfig.setScopeModel(this.applicationModel);
        this.configManager.addConfigCenter(configCenterConfig);
        return this;
    }

    public DubboBootstrap configCenters(List<ConfigCenterConfig> configCenterConfigs) {
        if (CollectionUtils.isEmpty(configCenterConfigs)) {
            return this;
        }
        for (ConfigCenterConfig configCenterConfig : configCenterConfigs) {
            this.configCenter(configCenterConfig);
        }
        return this;
    }

    public DubboBootstrap monitor(MonitorConfig monitor) {
        monitor.setScopeModel(this.applicationModel);
        this.configManager.setMonitor(monitor);
        return this;
    }

    public DubboBootstrap metrics(MetricsConfig metrics) {
        metrics.setScopeModel(this.applicationModel);
        this.configManager.setMetrics(metrics);
        return this;
    }

    public DubboBootstrap tracing(TracingConfig tracing) {
        tracing.setScopeModel(this.applicationModel);
        this.configManager.setTracing(tracing);
        return this;
    }

    public DubboBootstrap ssl(SslConfig sslConfig) {
        sslConfig.setScopeModel(this.applicationModel);
        this.configManager.setSsl(sslConfig);
        return this;
    }

    private ApplicationBuilder createApplicationBuilder(String name) {
        return new ApplicationBuilder().name(name);
    }

    private RegistryBuilder createRegistryBuilder(String id) {
        return new RegistryBuilder().id(id);
    }

    private MetadataReportBuilder createMetadataReportBuilder(String id) {
        return (MetadataReportBuilder)new MetadataReportBuilder().id(id);
    }

    private ConfigCenterBuilder createConfigCenterBuilder(String id) {
        return (ConfigCenterBuilder)new ConfigCenterBuilder().id(id);
    }

    private ProtocolBuilder createProtocolBuilder(String id) {
        return new ProtocolBuilder().id(id);
    }

    private ServiceBuilder createServiceBuilder(String id) {
        return new ServiceBuilder().id(id);
    }

    private ReferenceBuilder createReferenceBuilder(String id) {
        return new ReferenceBuilder().id(id);
    }

    private ProviderBuilder createProviderBuilder(String id) {
        return (ProviderBuilder)new ProviderBuilder().id(id);
    }

    private ConsumerBuilder createConsumerBuilder(String id) {
        return (ConsumerBuilder)new ConsumerBuilder().id(id);
    }

    public Module newModule() {
        return new Module(this.applicationModel.newModule());
    }

    public Module newModule(ModuleConfig moduleConfig) {
        ModuleModel moduleModel = this.applicationModel.newModule();
        moduleConfig.setScopeModel(moduleModel);
        moduleModel.getConfigManager().setModule(moduleConfig);
        return new Module(moduleModel);
    }

    public DubboBootstrap endModule() {
        return this;
    }

    public class Module {
        private ModuleModel moduleModel;
        private DubboBootstrap bootstrap;

        public Module(ModuleModel moduleModel) {
            this.moduleModel = moduleModel;
            this.bootstrap = DubboBootstrap.this;
        }

        public DubboBootstrap endModule() {
            return this.bootstrap.endModule();
        }

        public ModuleModel getModuleModel() {
            return this.moduleModel;
        }

        public Module config(ModuleConfig moduleConfig) {
            this.moduleModel.getConfigManager().setModule(moduleConfig);
            return this;
        }

        public <S> Module service(Consumer<ServiceBuilder<S>> consumerBuilder) {
            return this.service(null, consumerBuilder);
        }

        public <S> Module service(String id, Consumer<ServiceBuilder<S>> consumerBuilder) {
            return this.service(DubboBootstrap.this.createServiceConfig(id, consumerBuilder));
        }

        public Module services(List<ServiceConfig> serviceConfigs) {
            if (CollectionUtils.isEmpty(serviceConfigs)) {
                return this;
            }
            for (ServiceConfig serviceConfig : serviceConfigs) {
                this.service(serviceConfig);
            }
            return this;
        }

        public Module service(ServiceConfig<?> serviceConfig) {
            DubboBootstrap.this.service(serviceConfig, this.moduleModel);
            return this;
        }

        public <S> Module reference(Consumer<ReferenceBuilder<S>> consumerBuilder) {
            return this.reference(null, consumerBuilder);
        }

        public <S> Module reference(String id, Consumer<ReferenceBuilder<S>> consumerBuilder) {
            return this.reference(DubboBootstrap.this.createReferenceConfig(id, consumerBuilder));
        }

        public Module reference(ReferenceConfig<?> referenceConfig) {
            DubboBootstrap.this.reference(referenceConfig, this.moduleModel);
            return this;
        }

        public Module references(List<ReferenceConfig> referenceConfigs) {
            if (CollectionUtils.isEmpty(referenceConfigs)) {
                return this;
            }
            for (ReferenceConfig referenceConfig : referenceConfigs) {
                this.reference(referenceConfig);
            }
            return this;
        }

        public Module provider(Consumer<ProviderBuilder> builderConsumer) {
            return this.provider(null, builderConsumer);
        }

        public Module provider(String id, Consumer<ProviderBuilder> builderConsumer) {
            return this.provider(DubboBootstrap.this.createProviderConfig(id, builderConsumer));
        }

        public Module provider(ProviderConfig providerConfig) {
            DubboBootstrap.this.provider(providerConfig, this.moduleModel);
            return this;
        }

        public Module providers(List<ProviderConfig> providerConfigs) {
            if (CollectionUtils.isEmpty(providerConfigs)) {
                return this;
            }
            for (ProviderConfig providerConfig : providerConfigs) {
                DubboBootstrap.this.provider(providerConfig, this.moduleModel);
            }
            return this;
        }

        public Module consumer(Consumer<ConsumerBuilder> builderConsumer) {
            return this.consumer(null, builderConsumer);
        }

        public Module consumer(String id, Consumer<ConsumerBuilder> builderConsumer) {
            return this.consumer(DubboBootstrap.this.createConsumerConfig(id, builderConsumer));
        }

        public Module consumer(ConsumerConfig consumerConfig) {
            DubboBootstrap.this.consumer(consumerConfig, this.moduleModel);
            return this;
        }

        public Module consumers(List<ConsumerConfig> consumerConfigs) {
            if (CollectionUtils.isEmpty(consumerConfigs)) {
                return this;
            }
            for (ConsumerConfig consumerConfig : consumerConfigs) {
                DubboBootstrap.this.consumer(consumerConfig, this.moduleModel);
            }
            return this;
        }
    }
}

