/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2;

import com.alibaba.com.caucho.hessian.io.SerializerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.serialize.hessian2.Hessian2SerializerFactory;
import org.apache.dubbo.common.utils.DefaultSerializeClassChecker;
import org.apache.dubbo.common.utils.SerializeCheckStatus;
import org.apache.dubbo.common.utils.SerializeSecurityManager;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class Hessian2FactoryManager {
    String WHITELIST = "dubbo.application.hessian2.whitelist";
    String ALLOW = "dubbo.application.hessian2.allow";
    String DENY = "dubbo.application.hessian2.deny";
    private volatile SerializerFactory SYSTEM_SERIALIZER_FACTORY;
    private final Map<ClassLoader, SerializerFactory> CL_2_SERIALIZER_FACTORY = new ConcurrentHashMap<ClassLoader, SerializerFactory>();
    private final SerializeSecurityManager serializeSecurityManager;
    private final DefaultSerializeClassChecker defaultSerializeClassChecker;

    public Hessian2FactoryManager(FrameworkModel frameworkModel) {
        this.serializeSecurityManager = frameworkModel.getBeanFactory().getOrRegisterBean(SerializeSecurityManager.class);
        this.defaultSerializeClassChecker = frameworkModel.getBeanFactory().getOrRegisterBean(DefaultSerializeClassChecker.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializerFactory getSerializerFactory(ClassLoader classLoader) {
        if (classLoader == null) {
            if (this.SYSTEM_SERIALIZER_FACTORY == null) {
                Hessian2FactoryManager hessian2FactoryManager = this;
                synchronized (hessian2FactoryManager) {
                    if (this.SYSTEM_SERIALIZER_FACTORY == null) {
                        this.SYSTEM_SERIALIZER_FACTORY = this.createSerializerFactory();
                    }
                }
            }
            return this.SYSTEM_SERIALIZER_FACTORY;
        }
        if (!this.CL_2_SERIALIZER_FACTORY.containsKey(classLoader)) {
            Hessian2FactoryManager hessian2FactoryManager = this;
            synchronized (hessian2FactoryManager) {
                if (!this.CL_2_SERIALIZER_FACTORY.containsKey(classLoader)) {
                    SerializerFactory serializerFactory = this.createSerializerFactory();
                    this.CL_2_SERIALIZER_FACTORY.put(classLoader, serializerFactory);
                    return serializerFactory;
                }
            }
        }
        return this.CL_2_SERIALIZER_FACTORY.get(classLoader);
    }

    private SerializerFactory createSerializerFactory() {
        String whitelist = System.getProperty(this.WHITELIST);
        if (StringUtils.isNotEmpty(whitelist)) {
            return this.createWhiteListSerializerFactory();
        }
        return this.createDefaultSerializerFactory();
    }

    private SerializerFactory createDefaultSerializerFactory() {
        Hessian2SerializerFactory hessian2SerializerFactory = new Hessian2SerializerFactory(this.defaultSerializeClassChecker);
        hessian2SerializerFactory.setAllowNonSerializable(Boolean.parseBoolean(System.getProperty("dubbo.hessian.allowNonSerializable", "false")));
        hessian2SerializerFactory.getClassFactory().allow("org.apache.dubbo.*");
        return hessian2SerializerFactory;
    }

    public SerializerFactory createWhiteListSerializerFactory() {
        Hessian2SerializerFactory serializerFactory = new Hessian2SerializerFactory(this.defaultSerializeClassChecker);
        String whiteList = System.getProperty(this.WHITELIST);
        if ("true".equals(whiteList)) {
            serializerFactory.getClassFactory().setWhitelist(true);
            String allowPattern = System.getProperty(this.ALLOW);
            if (StringUtils.isNotEmpty(allowPattern)) {
                for (String pattern : allowPattern.split(";")) {
                    serializerFactory.getClassFactory().allow(pattern);
                    this.serializeSecurityManager.addToAlwaysAllowed(pattern);
                }
            }
            this.serializeSecurityManager.setCheckStatus(SerializeCheckStatus.STRICT);
        } else {
            serializerFactory.getClassFactory().setWhitelist(false);
            String denyPattern = System.getProperty(this.DENY);
            if (StringUtils.isNotEmpty(denyPattern)) {
                for (String pattern : denyPattern.split(";")) {
                    serializerFactory.getClassFactory().deny(pattern);
                    this.serializeSecurityManager.addToDisAllowed(pattern);
                }
            }
        }
        serializerFactory.setAllowNonSerializable(Boolean.parseBoolean(System.getProperty("dubbo.hessian.allowNonSerializable", "false")));
        serializerFactory.getClassFactory().allow("org.apache.dubbo.*");
        return serializerFactory;
    }

    public void onRemoveClassLoader(ClassLoader classLoader) {
        this.CL_2_SERIALIZER_FACTORY.remove(classLoader);
    }
}

