/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson2;

import com.alibaba.fastjson2.filter.ContextAutoTypeBeforeHandler;
import com.alibaba.fastjson2.util.TypeUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.AllowClassNotifyListener;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.SerializeCheckStatus;
import org.apache.dubbo.common.utils.SerializeSecurityManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class Fastjson2SecurityManager
implements AllowClassNotifyListener {
    private volatile Handler securityFilter;
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(Fastjson2SecurityManager.class);
    private final SerializeSecurityManager securityManager;
    private volatile SerializeCheckStatus status = AllowClassNotifyListener.DEFAULT_STATUS;
    private volatile boolean checkSerializable = true;
    private volatile Set<String> allowedList = new ConcurrentHashSet<String>(1);
    private volatile Set<String> disAllowedList = new ConcurrentHashSet<String>(1);

    public Fastjson2SecurityManager(FrameworkModel frameworkModel) {
        this.securityManager = frameworkModel.getBeanFactory().getOrRegisterBean(SerializeSecurityManager.class);
        this.securityManager.registerListener(this);
        this.securityFilter = new Handler(AllowClassNotifyListener.DEFAULT_STATUS, this.securityManager, true, new String[0], new ConcurrentHashSet<String>());
    }

    @Override
    public synchronized void notifyPrefix(Set<String> allowedList, Set<String> disAllowedList) {
        this.allowedList = allowedList;
        this.disAllowedList = disAllowedList;
        this.securityFilter = new Handler(this.status, this.securityManager, this.checkSerializable, this.allowedList.toArray(new String[0]), this.disAllowedList);
    }

    @Override
    public synchronized void notifyCheckStatus(SerializeCheckStatus status) {
        this.status = status;
        this.securityFilter = new Handler(this.status, this.securityManager, this.checkSerializable, this.allowedList.toArray(new String[0]), this.disAllowedList);
    }

    @Override
    public synchronized void notifyCheckSerializable(boolean checkSerializable) {
        this.checkSerializable = checkSerializable;
        this.securityFilter = new Handler(this.status, this.securityManager, this.checkSerializable, this.allowedList.toArray(new String[0]), this.disAllowedList);
    }

    public Handler getSecurityFilter() {
        return this.securityFilter;
    }

    private static class DenyClass {
        private DenyClass() {
        }
    }

    public static class Handler
    extends ContextAutoTypeBeforeHandler {
        final SerializeCheckStatus status;
        final SerializeSecurityManager serializeSecurityManager;
        final Map<String, Class<?>> classCache = new ConcurrentHashMap(16, 0.75f, 1);
        final Set<String> disAllowedList;
        final boolean checkSerializable;

        public Handler(SerializeCheckStatus status, SerializeSecurityManager serializeSecurityManager, boolean checkSerializable, String[] acceptNames, Set<String> disAllowedList) {
            super(true, acceptNames);
            this.status = status;
            this.serializeSecurityManager = serializeSecurityManager;
            this.checkSerializable = checkSerializable;
            this.disAllowedList = disAllowedList;
        }

        public Class<?> apply(String typeName, Class<?> expectClass, long features) {
            Class tryLoad = super.apply(typeName, expectClass, features);
            if (tryLoad != null) {
                return tryLoad;
            }
            if (this.status == SerializeCheckStatus.STRICT) {
                String msg = "[Serialization Security] Serialized class " + typeName + " is not in allow list. Current mode is `STRICT`, will disallow to deserialize it by default. Please add it into security/serialize.allowlist or follow FAQ to configure it.";
                if (this.serializeSecurityManager.getWarnedClasses().add(typeName)) {
                    logger.error("4-21", "", "", msg);
                }
                return null;
            }
            Class<?> localClass = this.loadClassDirectly(typeName);
            if (localClass != null) {
                if (this.status == SerializeCheckStatus.WARN && this.serializeSecurityManager.getWarnedClasses().add(typeName)) {
                    logger.error("4-21", "", "", "[Serialization Security] Serialized class " + localClass.getName() + " is not in allow list. Current mode is `WARN`, will allow to deserialize it by default. Dubbo will set to `STRICT` mode by default in the future. Please add it into security/serialize.allowlist or follow FAQ to configure it.");
                }
                return localClass;
            }
            return null;
        }

        public boolean checkIfDisAllow(String typeName) {
            return this.disAllowedList.stream().anyMatch(typeName::startsWith);
        }

        public boolean isCheckSerializable() {
            return this.checkSerializable;
        }

        public Class<?> loadClassDirectly(String typeName) {
            Class origin;
            Class clazz = this.classCache.get(typeName);
            if (clazz == null && this.checkIfDisAllow(typeName)) {
                clazz = DenyClass.class;
                String msg = "[Serialization Security] Serialized class " + typeName + " is in disAllow list. Current mode is `WARN`, will disallow to deserialize it by default. Please add it into security/serialize.allowlist or follow FAQ to configure it.";
                if (this.serializeSecurityManager.getWarnedClasses().add(typeName)) {
                    logger.error("4-21", "", "", msg);
                }
            }
            if (clazz == null) {
                clazz = TypeUtils.getMapping((String)typeName);
            }
            if (clazz == null) {
                clazz = TypeUtils.loadClass((String)typeName);
            }
            if (clazz != null && (origin = this.classCache.putIfAbsent(typeName, clazz)) != null) {
                clazz = origin;
            }
            if (clazz == DenyClass.class) {
                return null;
            }
            return clazz;
        }
    }
}

