/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.support;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TimeoutCountDown;
import org.apache.dubbo.rpc.service.GenericService;

public class RpcUtils {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(RpcUtils.class);
    private static final AtomicLong INVOKE_ID = new AtomicLong(0L);

    public static Class<?> getReturnType(Invocation invocation) {
        try {
            String service;
            if (invocation != null && invocation.getInvoker() != null && invocation.getInvoker().getUrl() != null && invocation.getInvoker().getInterface() != GenericService.class && !invocation.getMethodName().startsWith("$") && StringUtils.isNotEmpty(service = invocation.getInvoker().getUrl().getServiceInterface())) {
                Method method = RpcUtils.getMethodByService(invocation, service);
                return method == null ? null : method.getReturnType();
            }
        }
        catch (Throwable t) {
            logger.warn("0-8", "", "", t.getMessage(), t);
        }
        return null;
    }

    public static Type[] getReturnTypes(Invocation invocation) {
        try {
            if (invocation != null && invocation.getInvoker() != null && invocation.getInvoker().getUrl() != null && invocation.getInvoker().getInterface() != GenericService.class && !invocation.getMethodName().startsWith("$")) {
                Method method;
                Type[] returnTypes = null;
                if (invocation instanceof RpcInvocation && (returnTypes = ((RpcInvocation)invocation).getReturnTypes()) != null) {
                    return returnTypes;
                }
                String service = invocation.getInvoker().getUrl().getServiceInterface();
                if (StringUtils.isNotEmpty(service) && (method = RpcUtils.getMethodByService(invocation, service)) != null) {
                    returnTypes = ReflectUtils.getReturnTypes(method);
                }
                if (returnTypes != null) {
                    return returnTypes;
                }
            }
        }
        catch (Throwable t) {
            logger.warn("0-8", "", "", t.getMessage(), t);
        }
        return null;
    }

    public static Long getInvocationId(Invocation inv) {
        String id = inv.getAttachment("id");
        return id == null ? null : new Long(id);
    }

    public static void attachInvocationIdIfAsync(URL url, Invocation inv) {
        if (RpcUtils.isAttachInvocationId(url, inv) && RpcUtils.getInvocationId(inv) == null && inv instanceof RpcInvocation) {
            inv.setAttachment("id", String.valueOf(INVOKE_ID.getAndIncrement()));
        }
    }

    private static boolean isAttachInvocationId(URL url, Invocation invocation) {
        String value = url.getMethodParameter(invocation.getMethodName(), "invocationid.autoattach");
        if (value == null) {
            return RpcUtils.isAsync(url, invocation);
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(value);
    }

    public static String getMethodName(Invocation invocation) {
        if ("$invoke".equals(invocation.getMethodName()) && invocation.getArguments() != null && invocation.getArguments().length > 0 && invocation.getArguments()[0] instanceof String) {
            return (String)invocation.getArguments()[0];
        }
        return invocation.getMethodName();
    }

    public static Object[] getArguments(Invocation invocation) {
        if ("$invoke".equals(invocation.getMethodName()) && invocation.getArguments() != null && invocation.getArguments().length > 2 && invocation.getArguments()[2] instanceof Object[]) {
            return (Object[])invocation.getArguments()[2];
        }
        return invocation.getArguments();
    }

    public static Class<?>[] getParameterTypes(Invocation invocation) {
        if ("$invoke".equals(invocation.getMethodName()) && invocation.getArguments() != null && invocation.getArguments().length > 1 && invocation.getArguments()[1] instanceof String[]) {
            String[] types = (String[])invocation.getArguments()[1];
            if (types == null) {
                return new Class[0];
            }
            Class[] parameterTypes = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                parameterTypes[i] = ReflectUtils.forName(types[i]);
            }
            return parameterTypes;
        }
        return invocation.getParameterTypes();
    }

    public static boolean isAsync(URL url, Invocation inv) {
        RpcInvocation rpcInvocation;
        if (inv instanceof RpcInvocation && (rpcInvocation = (RpcInvocation)inv).getInvokeMode() != null) {
            return rpcInvocation.getInvokeMode() == InvokeMode.ASYNC;
        }
        boolean isAsync = Boolean.TRUE.toString().equals(inv.getAttachment("async")) ? true : url.getMethodParameter(RpcUtils.getMethodName(inv), "async", false);
        return isAsync;
    }

    public static boolean isReturnTypeFuture(Invocation inv) {
        Class<?> clazz = inv instanceof RpcInvocation ? ((RpcInvocation)inv).getReturnType() : RpcUtils.getReturnType(inv);
        return clazz != null && CompletableFuture.class.isAssignableFrom(clazz) || RpcUtils.isGenericAsync(inv);
    }

    public static boolean isGenericAsync(Invocation inv) {
        return "$invokeAsync".equals(inv.getMethodName());
    }

    public static boolean isGenericCall(String parameterTypesDesc, String method) {
        return ("$invoke".equals(method) || "$invokeAsync".equals(method)) && "Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/Object;".equals(parameterTypesDesc);
    }

    public static boolean isEcho(String parameterTypesDesc, String method) {
        return "$echo".equals(method) && "Ljava/lang/Object;".equals(parameterTypesDesc);
    }

    public static InvokeMode getInvokeMode(URL url, Invocation inv) {
        RpcInvocation rpcInvocation;
        if (inv instanceof RpcInvocation && (rpcInvocation = (RpcInvocation)inv).getInvokeMode() != null) {
            return rpcInvocation.getInvokeMode();
        }
        if (RpcUtils.isReturnTypeFuture(inv)) {
            return InvokeMode.FUTURE;
        }
        if (RpcUtils.isAsync(url, inv)) {
            return InvokeMode.ASYNC;
        }
        return InvokeMode.SYNC;
    }

    public static boolean isOneway(URL url, Invocation inv) {
        boolean isOneway = Boolean.FALSE.toString().equals(inv.getAttachment("return")) ? true : !url.getMethodParameter(RpcUtils.getMethodName(inv), "return", true);
        return isOneway;
    }

    private static Method getMethodByService(Invocation invocation, String service) throws NoSuchMethodException {
        Class<?> invokerInterface = invocation.getInvoker().getInterface();
        Class<?> cls = invokerInterface != null ? ReflectUtils.forName(invokerInterface.getClassLoader(), service) : ReflectUtils.forName(service);
        Method method = cls.getMethod(invocation.getMethodName(), invocation.getParameterTypes());
        if (method.getReturnType() == Void.TYPE) {
            return null;
        }
        return method;
    }

    public static long getTimeout(Invocation invocation, long defaultTimeout) {
        long timeout = defaultTimeout;
        Object genericTimeout = invocation.getObjectAttachmentWithoutConvert("_TO");
        if (genericTimeout == null) {
            genericTimeout = invocation.getObjectAttachmentWithoutConvert("_to");
        }
        if (genericTimeout != null) {
            timeout = RpcUtils.convertToNumber(genericTimeout, defaultTimeout);
        }
        return timeout;
    }

    public static long getTimeout(URL url, String methodName, RpcContext context, Invocation invocation, long defaultTimeout) {
        long timeout = defaultTimeout;
        Object timeoutFromContext = context.getObjectAttachment("timeout");
        Object timeoutFromInvocation = invocation.getObjectAttachment("timeout");
        if (timeoutFromContext != null) {
            timeout = RpcUtils.convertToNumber(timeoutFromContext, defaultTimeout);
        } else if (timeoutFromInvocation != null) {
            timeout = RpcUtils.convertToNumber(timeoutFromInvocation, defaultTimeout);
        } else if (url != null) {
            timeout = url.getMethodPositiveParameter(methodName, "timeout", defaultTimeout);
        }
        return timeout;
    }

    public static int calculateTimeout(URL url, Invocation invocation, String methodName, long defaultTimeout) {
        Object countdown = RpcContext.getClientAttachment().getObjectAttachment("timeout-countdown");
        int timeout = (int)defaultTimeout;
        if (countdown == null) {
            if (url != null) {
                timeout = (int)RpcUtils.getTimeout(url, methodName, RpcContext.getClientAttachment(), invocation, defaultTimeout);
                if (url.getMethodParameter(methodName, "enable-timeout-countdown", false)) {
                    invocation.setObjectAttachment("_TO", timeout);
                }
            }
        } else {
            TimeoutCountDown timeoutCountDown = (TimeoutCountDown)countdown;
            timeout = (int)timeoutCountDown.timeRemaining(TimeUnit.MILLISECONDS);
            invocation.setObjectAttachment("_TO", timeout);
        }
        invocation.getObjectAttachments().remove("timeout-countdown");
        return timeout;
    }

    public static Long convertToNumber(Object obj, long defaultTimeout) {
        Long timeout = RpcUtils.convertToNumber(obj);
        return timeout == null ? defaultTimeout : timeout;
    }

    public static Long convertToNumber(Object obj) {
        Long timeout = null;
        try {
            timeout = obj instanceof String ? Long.valueOf(Long.parseLong((String)obj)) : (obj instanceof Number ? Long.valueOf(((Number)obj).longValue()) : Long.valueOf(Long.parseLong(obj.toString())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeout;
    }
}

