/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import io.netty.handler.codec.http2.Http2Headers;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;
import org.apache.dubbo.rpc.protocol.tri.transport.H2TransportListener;

public abstract class AbstractH2TransportListener
implements H2TransportListener {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(AbstractH2TransportListener.class);

    protected Map<String, Object> headersToMap(Http2Headers trailers, Supplier<Object> convertUpperHeaderSupplier) {
        if (trailers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>(trailers.size());
        for (Map.Entry header : trailers) {
            String key = ((CharSequence)header.getKey()).toString();
            if (key.endsWith("-bin") && key.length() > "-bin".length()) {
                try {
                    String realKey = key.substring(0, key.length() - "-bin".length());
                    byte[] value = StreamUtils.decodeASCIIByte((CharSequence)header.getValue());
                    attachments.put(realKey, value);
                }
                catch (Exception e) {
                    LOGGER.error("4-9", "", "", "Failed to parse response attachment key=" + key, e);
                }
                continue;
            }
            attachments.put(key, ((CharSequence)header.getValue()).toString());
        }
        Object obj = convertUpperHeaderSupplier.get();
        if (obj == null) {
            return attachments;
        }
        if (obj instanceof String) {
            String json = TriRpcStatus.decodeMessage((String)obj);
            Map map = (Map)JsonUtils.getJson().toJavaObject(json, (Type)((Object)Map.class));
            for (Map.Entry entry : map.entrySet()) {
                Object val = attachments.remove(entry.getKey());
                if (val == null) continue;
                attachments.put((String)entry.getValue(), val);
            }
        } else {
            LOGGER.error("99-0", "wrong internal invocation", "", "Triple convertNoLowerCaseHeader error, obj is not String");
        }
        return attachments;
    }

    protected Map<String, String> filterReservedHeaders(Http2Headers trailers) {
        if (trailers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> excludeHeaders = new HashMap<String, String>(trailers.size());
        for (Map.Entry header : trailers) {
            String key = ((CharSequence)header.getKey()).toString();
            if (!TripleHeaderEnum.containsExcludeAttachments(key)) continue;
            excludeHeaders.put(key, ((CharSequence)trailers.getAndRemove((Object)key)).toString());
        }
        return excludeHeaders;
    }
}

