/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import java.net.InetSocketAddress;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.CancellationContext;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.call.ServerCall;
import org.apache.dubbo.rpc.protocol.tri.observer.ServerCallToObserverAdapter;

public abstract class AbstractServerCallListener
implements ServerCall.Listener {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(AbstractServerCallListener.class);
    public final CancellationContext cancellationContext;
    final RpcInvocation invocation;
    final Invoker<?> invoker;
    final ServerCallToObserverAdapter<Object> responseObserver;

    public AbstractServerCallListener(RpcInvocation invocation, Invoker<?> invoker, ServerCallToObserverAdapter<Object> responseObserver) {
        this.invocation = invocation;
        this.invoker = invoker;
        this.cancellationContext = responseObserver.cancellationContext;
        this.responseObserver = responseObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        RpcContext.restoreCancellationContext(this.cancellationContext);
        InetSocketAddress remoteAddress = (InetSocketAddress)this.invocation.getAttributes().remove("tri.remote.address");
        RpcContext.getServiceContext().setRemoteAddress(remoteAddress);
        String remoteApp = (String)this.invocation.getAttributes().remove((Object)TripleHeaderEnum.CONSUMER_APP_NAME_KEY);
        if (null != remoteApp) {
            RpcContext.getServiceContext().setRemoteApplicationName(remoteApp);
            this.invocation.setAttachmentIfAbsent("remote.application", remoteApp);
        }
        long stInMillis = System.currentTimeMillis();
        try {
            Result response = this.invoker.invoke(this.invocation);
            response.whenCompleteWithContext((r, t) -> {
                this.responseObserver.setResponseAttachments(response.getObjectAttachments());
                if (t != null) {
                    this.responseObserver.onError((Throwable)t);
                    return;
                }
                if (response.hasException()) {
                    this.onReturn(response.getException());
                    return;
                }
                long cost = System.currentTimeMillis() - stInMillis;
                if (this.responseObserver.isTimeout(cost)) {
                    LOGGER.error("4-13", "", "", String.format("Invoke timeout at server side, ignored to send response. service=%s method=%s cost=%s", this.invocation.getTargetServiceUniqueName(), this.invocation.getMethodName(), cost));
                    this.responseObserver.onCompleted(TriRpcStatus.DEADLINE_EXCEEDED);
                    return;
                }
                this.onReturn(r.getValue());
            });
        }
        catch (Exception e) {
            this.responseObserver.onError(e);
        }
        finally {
            RpcContext.removeCancellationContext();
            RpcContext.removeContext();
        }
    }

    public abstract void onReturn(Object var1);
}

