/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.message.codec;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodec;
import org.apache.dubbo.rpc.protocol.rest.message.MediaTypeMatcher;
import org.apache.dubbo.rpc.protocol.rest.util.DataParseUtils;

@Activate(value={"text"})
public class TextCodec
implements HttpMessageCodec<byte[], OutputStream> {
    @Override
    public Object decode(byte[] body, Class targetType) throws Exception {
        return DataParseUtils.stringTypeConvert(targetType, new String(body, StandardCharsets.UTF_8));
    }

    @Override
    public boolean contentTypeSupport(MediaType mediaType, Class targetType) {
        return MediaTypeMatcher.TEXT_PLAIN.mediaSupport(mediaType);
    }

    @Override
    public void encode(OutputStream outputStream, Object unSerializedBody, URL url) throws Exception {
        DataParseUtils.writeTextContent(unSerializedBody, outputStream);
    }
}

