/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.message.codec;

import java.io.OutputStream;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.rest.media.MediaType;
import org.apache.dubbo.rpc.protocol.rest.message.HttpMessageCodec;
import org.apache.dubbo.rpc.protocol.rest.message.MediaTypeMatcher;
import org.apache.dubbo.rpc.protocol.rest.util.DataParseUtils;

@Activate(value={"multiValue"})
public class MultiValueCodec
implements HttpMessageCodec<byte[], OutputStream> {
    @Override
    public Object decode(byte[] body, Class targetType) throws Exception {
        return DataParseUtils.multipartFormConvert(body);
    }

    @Override
    public boolean contentTypeSupport(MediaType mediaType, Class targetType) {
        return MediaTypeMatcher.MULTI_VALUE.mediaSupport(mediaType);
    }

    @Override
    public void encode(OutputStream outputStream, Object unSerializedBody, URL url) throws Exception {
        DataParseUtils.writeFormContent((Map)unSerializedBody, outputStream);
    }
}

