/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.annotation.consumer.inercept;

import java.util.Collection;
import java.util.Set;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionCreateContext;
import org.apache.dubbo.rpc.protocol.rest.annotation.consumer.HttpConnectionPreBuildIntercept;

@Activate(value={"header"}, order=2)
public class RequestHeaderIntercept
implements HttpConnectionPreBuildIntercept {
    @Override
    public void intercept(HttpConnectionCreateContext connectionCreateContext) {
        RestMethodMetadata restMethodMetadata = connectionCreateContext.getRestMethodMetadata();
        RequestTemplate requestTemplate = connectionCreateContext.getRequestTemplate();
        Set<String> consumes = restMethodMetadata.getRequest().getConsumes();
        requestTemplate.addHeaders("Content-Type", consumes);
        Collection<String> headers = requestTemplate.getHeaders("Accept");
        if (headers == null || headers.isEmpty()) {
            requestTemplate.addHeader("Accept", "*/*");
        }
    }
}

