/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.io.Bytes;
import org.apache.dubbo.common.io.UnsafeByteArrayInputStream;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.exchange.HeartBeatRequest;
import org.apache.dubbo.remoting.exchange.HeartBeatResponse;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.codec.ExchangeCodec;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.dubbo.CallbackServiceCodec;
import org.apache.dubbo.rpc.protocol.dubbo.DecodeableRpcInvocation;
import org.apache.dubbo.rpc.protocol.dubbo.DecodeableRpcResult;
import org.apache.dubbo.rpc.protocol.dubbo.DubboCodecSupport;

public class DubboCodec
extends ExchangeCodec {
    public static final String NAME = "dubbo";
    public static final String DUBBO_VERSION = Version.getProtocolVersion();
    public static final byte RESPONSE_WITH_EXCEPTION = 0;
    public static final byte RESPONSE_VALUE = 1;
    public static final byte RESPONSE_NULL_VALUE = 2;
    public static final byte RESPONSE_WITH_EXCEPTION_WITH_ATTACHMENTS = 3;
    public static final byte RESPONSE_VALUE_WITH_ATTACHMENTS = 4;
    public static final byte RESPONSE_NULL_VALUE_WITH_ATTACHMENTS = 5;
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final ErrorTypeAwareLogger log = LoggerFactory.getErrorTypeAwareLogger(DubboCodec.class);
    private static final AtomicBoolean decodeInUserThreadLogged = new AtomicBoolean(false);
    private final CallbackServiceCodec callbackServiceCodec;
    private final FrameworkModel frameworkModel;

    public DubboCodec(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.callbackServiceCodec = new CallbackServiceCodec(frameworkModel);
    }

    @Override
    protected Object decodeBody(Channel channel, InputStream is, byte[] header) throws IOException {
        Request req;
        byte flag = header[2];
        byte proto = (byte)(flag & 0x1F);
        long id = Bytes.bytes2long(header, 4);
        if ((flag & 0xFFFFFF80) == 0) {
            Response res = new Response(id);
            if ((flag & 0x20) != 0) {
                res.setEvent(true);
            }
            byte status = header[3];
            res.setStatus(status);
            try {
                if (status == 20) {
                    Object data;
                    if (res.isEvent()) {
                        byte[] eventPayload = CodecSupport.getPayload(is);
                        if (CodecSupport.isHeartBeat(eventPayload, proto)) {
                            data = null;
                        } else {
                            ObjectInput in = CodecSupport.deserialize(channel.getUrl(), new ByteArrayInputStream(eventPayload), proto);
                            data = this.decodeEventData(channel, in, eventPayload);
                        }
                    } else {
                        DecodeableRpcResult result;
                        if (channel.getUrl().getParameter("decode.in.io", false)) {
                            result = new DecodeableRpcResult(channel, res, is, (Invocation)this.getRequestData(id), proto);
                            result.decode();
                        } else {
                            result = new DecodeableRpcResult(channel, res, new UnsafeByteArrayInputStream(this.readMessageData(is)), (Invocation)this.getRequestData(id), proto);
                        }
                        data = result;
                    }
                    res.setResult(data);
                } else {
                    ObjectInput in = CodecSupport.deserialize(channel.getUrl(), is, proto);
                    res.setErrorMessage(in.readUTF());
                }
            }
            catch (Throwable t) {
                if (log.isWarnEnabled()) {
                    log.warn("4-20", "", "", "Decode response failed: " + t.getMessage(), t);
                }
                res.setStatus((byte)90);
                res.setErrorMessage(StringUtils.toString(t));
            }
            return res;
        }
        try {
            Object data;
            if ((flag & 0x20) != 0) {
                byte[] eventPayload = CodecSupport.getPayload(is);
                if (CodecSupport.isHeartBeat(eventPayload, proto)) {
                    req = new HeartBeatRequest(id);
                    ((HeartBeatRequest)req).setProto(proto);
                    data = null;
                } else {
                    req = new Request(id);
                    ObjectInput in = CodecSupport.deserialize(channel.getUrl(), new ByteArrayInputStream(eventPayload), proto);
                    data = this.decodeEventData(channel, in, eventPayload);
                }
                req.setEvent(true);
            } else {
                DecodeableRpcInvocation inv;
                req = new HeartBeatRequest(id);
                if (this.isDecodeDataInIoThread(channel)) {
                    inv = new DecodeableRpcInvocation(this.frameworkModel, channel, req, is, proto);
                    inv.decode();
                } else {
                    inv = new DecodeableRpcInvocation(this.frameworkModel, channel, req, new UnsafeByteArrayInputStream(this.readMessageData(is)), proto);
                }
                data = inv;
            }
            req.setData(data);
        }
        catch (Throwable t) {
            if (log.isWarnEnabled()) {
                log.warn("4-20", "", "", "Decode request failed: " + t.getMessage(), t);
            }
            req = new HeartBeatRequest(id);
            req.setBroken(true);
            req.setData(t);
        }
        req.setVersion(Version.getProtocolVersion());
        req.setTwoWay((flag & 0x40) != 0);
        return req;
    }

    private boolean isDecodeDataInIoThread(Channel channel) {
        boolean decodeDataInIoThread = channel.getUrl().getParameter("decode.in.io", false);
        String mode = ExecutorRepository.getMode(channel.getUrl().getOrDefaultApplicationModel());
        if ("isolation".equals(mode)) {
            if (!decodeDataInIoThread && decodeInUserThreadLogged.compareAndSet(false, true)) {
                log.info("Because thread pool isolation is enabled on the dubbo protocol, the body can only be decoded on the io thread, and the parameter[decode.in.io] will be ignored");
            }
            return true;
        }
        return decodeDataInIoThread;
    }

    private byte[] readMessageData(InputStream is) throws IOException {
        if (is.available() > 0) {
            byte[] result = new byte[is.available()];
            is.read(result);
            return result;
        }
        return new byte[0];
    }

    @Override
    protected void encodeRequestData(Channel channel, ObjectOutput out, Object data) throws IOException {
        this.encodeRequestData(channel, out, data, DUBBO_VERSION);
    }

    @Override
    protected void encodeResponseData(Channel channel, ObjectOutput out, Object data) throws IOException {
        this.encodeResponseData(channel, out, data, DUBBO_VERSION);
    }

    @Override
    protected void encodeRequestData(Channel channel, ObjectOutput out, Object data, String version) throws IOException {
        RpcInvocation inv = (RpcInvocation)data;
        out.writeUTF(version);
        String serviceName = inv.getAttachment("interface");
        if (serviceName == null) {
            serviceName = inv.getAttachment("path");
        }
        out.writeUTF(serviceName);
        out.writeUTF(inv.getAttachment("version"));
        out.writeUTF(inv.getMethodName());
        out.writeUTF(inv.getParameterTypesDesc());
        Object[] args = inv.getArguments();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                out.writeObject(this.callbackServiceCodec.encodeInvocationArgument(channel, inv, i));
            }
        }
        out.writeAttachments(inv.getObjectAttachments());
    }

    @Override
    protected void encodeResponseData(Channel channel, ObjectOutput out, Object data, String version) throws IOException {
        Result result = (Result)data;
        boolean attach = Version.isSupportResponseAttachment(version);
        Throwable th = result.getException();
        if (th == null) {
            Object ret = result.getValue();
            if (ret == null) {
                out.writeByte(attach ? (byte)5 : 2);
            } else {
                out.writeByte(attach ? (byte)4 : 1);
                out.writeObject(ret);
            }
        } else {
            out.writeByte(attach ? (byte)3 : 0);
            out.writeThrowable(th);
        }
        if (attach) {
            result.getObjectAttachments().put(NAME, Version.getProtocolVersion());
            out.writeAttachments(result.getObjectAttachments());
        }
    }

    @Override
    protected Serialization getSerialization(Channel channel, Request req) {
        if (!(req.getData() instanceof Invocation)) {
            return super.getSerialization(channel, req);
        }
        return DubboCodecSupport.getRequestSerialization(channel.getUrl(), (Invocation)req.getData());
    }

    @Override
    protected Serialization getSerialization(Channel channel, Response res) {
        if (res instanceof HeartBeatResponse) {
            return CodecSupport.getSerializationById(((HeartBeatResponse)res).getProto());
        }
        if (!(res.getResult() instanceof AppResponse)) {
            return super.getSerialization(channel, res);
        }
        return DubboCodecSupport.getResponseSerialization(channel.getUrl(), (AppResponse)res.getResult());
    }
}

