/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.HashMap;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ModuleEnvironment;
import org.apache.dubbo.common.context.ModuleExt;
import org.apache.dubbo.common.deploy.ApplicationDeployer;
import org.apache.dubbo.common.deploy.DeployState;
import org.apache.dubbo.common.deploy.ModuleDeployer;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.config.context.ModuleConfigManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.AsyncMethodInfo;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelInitializer;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public class ModuleModel
extends ScopeModel {
    private static final Logger logger = LoggerFactory.getLogger(ModuleModel.class);
    public static final String NAME = "ModuleModel";
    private final ApplicationModel applicationModel;
    private volatile ModuleServiceRepository serviceRepository;
    private volatile ModuleEnvironment moduleEnvironment;
    private volatile ModuleConfigManager moduleConfigManager;
    private volatile ModuleDeployer deployer;
    private boolean lifeCycleManagedExternally = false;

    protected ModuleModel(ApplicationModel applicationModel) {
        this(applicationModel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModuleModel(ApplicationModel applicationModel, boolean isInternal) {
        super(applicationModel, ExtensionScope.MODULE, isInternal);
        Object object = this.instLock;
        synchronized (object) {
            Assert.notNull((Object)applicationModel, "ApplicationModel can not be null");
            this.applicationModel = applicationModel;
            applicationModel.addModule(this, isInternal);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(this.getDesc() + " is created");
            }
            this.initialize();
            this.serviceRepository = new ModuleServiceRepository(this);
            this.initModuleExt();
            ExtensionLoader<ScopeModelInitializer> initializerExtensionLoader = this.getExtensionLoader(ScopeModelInitializer.class);
            Set<ScopeModelInitializer> initializers = initializerExtensionLoader.getSupportedExtensionInstances();
            for (ScopeModelInitializer initializer : initializers) {
                initializer.initializeModuleModel(this);
            }
            Assert.notNull((Object)this.getServiceRepository(), "ModuleServiceRepository can not be null");
            Assert.notNull((Object)this.getConfigManager(), "ModuleConfigManager can not be null");
            Assert.assertTrue(this.getConfigManager().isInitialized(), "ModuleConfigManager can not be initialized");
            ApplicationDeployer applicationDeployer = applicationModel.getDeployer();
            if (applicationDeployer != null) {
                applicationDeployer.notifyModuleChanged(this, DeployState.PENDING);
            }
        }
    }

    private void initModuleExt() {
        Set<ModuleExt> exts = this.getExtensionLoader(ModuleExt.class).getSupportedExtensionInstances();
        for (ModuleExt ext : exts) {
            ext.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDestroy() {
        Object object = this.instLock;
        synchronized (object) {
            this.applicationModel.removeModule(this);
            if (this.deployer != null) {
                this.deployer.preDestroy();
            }
            if (this.deployer != null) {
                this.deployer.postDestroy();
            }
            this.notifyDestroy();
            if (this.serviceRepository != null) {
                this.serviceRepository.destroy();
                this.serviceRepository = null;
            }
            if (this.moduleEnvironment != null) {
                this.moduleEnvironment.destroy();
                this.moduleEnvironment = null;
            }
            if (this.moduleConfigManager != null) {
                this.moduleConfigManager.destroy();
                this.moduleConfigManager = null;
            }
            this.applicationModel.tryDestroy();
        }
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public ModuleServiceRepository getServiceRepository() {
        return this.serviceRepository;
    }

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        super.addClassLoader(classLoader);
        if (this.moduleEnvironment != null) {
            this.moduleEnvironment.refreshClassLoaders();
        }
    }

    @Override
    public ModuleEnvironment getModelEnvironment() {
        if (this.moduleEnvironment == null) {
            this.moduleEnvironment = (ModuleEnvironment)this.getExtensionLoader(ModuleExt.class).getExtension("moduleEnvironment");
        }
        return this.moduleEnvironment;
    }

    public ModuleConfigManager getConfigManager() {
        if (this.moduleConfigManager == null) {
            this.moduleConfigManager = (ModuleConfigManager)this.getExtensionLoader(ModuleExt.class).getExtension("moduleConfig");
        }
        return this.moduleConfigManager;
    }

    public ModuleDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(ModuleDeployer deployer) {
        this.deployer = deployer;
    }

    @Deprecated
    public void setModuleEnvironment(ModuleEnvironment moduleEnvironment) {
        this.moduleEnvironment = moduleEnvironment;
    }

    public ConsumerModel registerInternalConsumer(Class<?> internalService, URL url) {
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setVersion(url.getVersion());
        serviceMetadata.setGroup(url.getGroup());
        serviceMetadata.setDefaultGroup(url.getGroup());
        serviceMetadata.setServiceInterfaceName(internalService.getName());
        serviceMetadata.setServiceType(internalService);
        String serviceKey = URL.buildKey(internalService.getName(), url.getGroup(), url.getVersion());
        serviceMetadata.setServiceKey(serviceKey);
        ConsumerModel consumerModel = new ConsumerModel(serviceMetadata.getServiceKey(), "jdk", this.serviceRepository.lookupService(serviceMetadata.getServiceInterfaceName()), this, serviceMetadata, new HashMap<String, AsyncMethodInfo>(0), ClassUtils.getClassLoader(internalService));
        logger.info("Dynamically registering consumer model " + serviceKey + " into model " + this.getDesc());
        this.serviceRepository.registerConsumer(consumerModel);
        return consumerModel;
    }

    public boolean isLifeCycleManagedExternally() {
        return this.lifeCycleManagedExternally;
    }

    public void setLifeCycleManagedExternally(boolean lifeCycleManagedExternally) {
        this.lifeCycleManagedExternally = lifeCycleManagedExternally;
    }
}

