/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http.restclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.remoting.http.RestClient;
import org.apache.dubbo.remoting.http.RestResult;
import org.apache.dubbo.remoting.http.config.HttpClientConfig;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpClientRestClient
implements RestClient {
    private final CloseableHttpClient closeableHttpClient = this.createHttpClient();
    private final HttpClientConfig httpClientConfig;

    public HttpClientRestClient(HttpClientConfig clientConfig) {
        this.httpClientConfig = clientConfig;
    }

    @Override
    public CompletableFuture<RestResult> send(RequestTemplate requestTemplate) {
        HttpGet httpRequest = null;
        String httpMethod = requestTemplate.getHttpMethod();
        if ("GET".equals(httpMethod)) {
            httpRequest = new HttpGet(requestTemplate.getURL());
        } else if ("POST".equals(httpMethod)) {
            HttpPost httpPost = new HttpPost(requestTemplate.getURL());
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(requestTemplate.getSerializedBody()));
            httpRequest = httpPost;
        }
        Map<String, Collection<String>> allHeaders = requestTemplate.getAllHeaders();
        allHeaders.remove("Content-Length");
        for (String headerName : allHeaders.keySet()) {
            Collection<String> headerValues = allHeaders.get(headerName);
            for (String headerValue : headerValues) {
                httpRequest.addHeader(headerName, headerValue);
            }
        }
        httpRequest.setConfig(this.getRequestConfig(this.httpClientConfig));
        CompletableFuture<RestResult> future = new CompletableFuture<RestResult>();
        try {
            final CloseableHttpResponse response = this.closeableHttpClient.execute((HttpUriRequest)httpRequest);
            future.complete(new RestResult(){

                @Override
                public String getContentType() {
                    return response.getFirstHeader("Content-Type").getValue();
                }

                @Override
                public byte[] getBody() throws IOException {
                    return IOUtils.toByteArray((InputStream)response.getEntity().getContent());
                }

                @Override
                public Map<String, List<String>> headers() {
                    return Arrays.stream(response.getAllHeaders()).collect(Collectors.toMap(NameValuePair::getName, h -> Collections.singletonList(h.getValue())));
                }

                @Override
                public byte[] getErrorResponse() throws IOException {
                    return this.getBody();
                }

                @Override
                public int getResponseCode() {
                    return response.getStatusLine().getStatusCode();
                }

                @Override
                public String getMessage() throws IOException {
                    return response.getStatusLine().getReasonPhrase();
                }
            });
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private RequestConfig getRequestConfig(HttpClientConfig clientConfig) {
        return RequestConfig.custom().build();
    }

    @Override
    public void close() {
        try {
            this.closeableHttpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close(int timeout) {
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    public CloseableHttpClient createHttpClient() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }
}

