/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support.header;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.Client;
import org.apache.dubbo.remoting.exchange.support.header.AbstractTimerTask;

public class ReconnectTimerTask
extends AbstractTimerTask {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ReconnectTimerTask.class);
    private final int idleTimeout;

    public ReconnectTimerTask(AbstractTimerTask.ChannelProvider channelProvider, Long heartbeatTimeoutTick, int idleTimeout) {
        super(channelProvider, heartbeatTimeoutTick);
        this.idleTimeout = idleTimeout;
    }

    @Override
    protected void doTask(Channel channel) {
        try {
            Long lastRead = ReconnectTimerTask.lastRead(channel);
            Long now = ReconnectTimerTask.now();
            if (!channel.isConnected()) {
                try {
                    logger.info("Initial connection to " + channel);
                    ((Client)channel).reconnect();
                }
                catch (Exception e) {
                    logger.error("6-16", "", "", "Fail to connect to" + channel, e);
                }
            } else if (lastRead != null && now - lastRead > (long)this.idleTimeout) {
                logger.warn("6-16", "", "", "Reconnect to channel " + channel + ", because heartbeat read idle time out: " + this.idleTimeout + "ms");
                try {
                    ((Client)channel).reconnect();
                }
                catch (Exception e) {
                    logger.error("6-16", "", "", channel + "reconnect failed during idle time.", e);
                }
            }
        }
        catch (Throwable t) {
            logger.warn("99-0", "unknown error in remoting module", "", "Exception when reconnect to remote channel " + channel.getRemoteAddress(), t);
        }
    }
}

