/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.event.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.ProtocolServiceKey;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metrics.event.SimpleMetricsEventMulticaster;
import org.apache.dubbo.metrics.model.TimePair;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.RetryServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceNotificationCustomizer;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class ServiceInstancesChangedListener {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ServiceInstancesChangedListener.class);
    protected final Set<String> serviceNames;
    protected final ServiceDiscovery serviceDiscovery;
    protected Map<String, Set<NotifyListenerWithKey>> listeners;
    protected AtomicBoolean destroyed = new AtomicBoolean(false);
    protected Map<String, List<ServiceInstance>> allInstances;
    protected Map<String, List<ProtocolServiceKeyWithUrls>> serviceUrls;
    private volatile long lastRefreshTime;
    private final Semaphore retryPermission;
    private volatile ScheduledFuture<?> retryFuture;
    private final ScheduledExecutorService scheduler;
    private volatile boolean hasEmptyMetadata;
    private final Set<ServiceInstanceNotificationCustomizer> serviceInstanceNotificationCustomizers;
    private final ApplicationModel applicationModel;

    public ServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery) {
        this.serviceNames = serviceNames;
        this.serviceDiscovery = serviceDiscovery;
        this.listeners = new ConcurrentHashMap<String, Set<NotifyListenerWithKey>>();
        this.allInstances = new HashMap<String, List<ServiceInstance>>();
        this.serviceUrls = new HashMap<String, List<ProtocolServiceKeyWithUrls>>();
        this.retryPermission = new Semaphore(1);
        ApplicationModel applicationModel = ScopeModelUtil.getApplicationModel(serviceDiscovery == null || serviceDiscovery.getUrl() == null ? null : serviceDiscovery.getUrl().getScopeModel());
        this.scheduler = applicationModel.getBeanFactory().getBean(FrameworkExecutorRepository.class).getMetadataRetryExecutor();
        this.serviceInstanceNotificationCustomizers = applicationModel.getExtensionLoader(ServiceInstanceNotificationCustomizer.class).getSupportedExtensionInstances();
        this.applicationModel = applicationModel;
    }

    public void onEvent(ServiceInstancesChangedEvent event) {
        if (this.destroyed.get() || !this.accept(event) || this.isRetryAndExpired(event)) {
            return;
        }
        this.doOnEvent(event);
    }

    private synchronized void doOnEvent(ServiceInstancesChangedEvent event) {
        if (this.destroyed.get() || !this.accept(event) || this.isRetryAndExpired(event)) {
            return;
        }
        this.refreshInstance(event);
        if (logger.isDebugEnabled()) {
            logger.debug(event.getServiceInstances().toString());
        }
        HashMap<String, List<ServiceInstance>> revisionToInstances = new HashMap<String, List<ServiceInstance>>();
        HashMap<MetadataInfo.ServiceInfo, Set<String>> localServiceToRevisions = new HashMap<MetadataInfo.ServiceInfo, Set<String>>();
        for (Map.Entry<String, List<ServiceInstance>> entry : this.allInstances.entrySet()) {
            List<ServiceInstance> instances = entry.getValue();
            for (ServiceInstance serviceInstance : instances) {
                String revision = ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance);
                if (revision == null || "0".equals(revision)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Find instance without valid service metadata: " + serviceInstance.getAddress());
                    continue;
                }
                List subInstances = revisionToInstances.computeIfAbsent(revision, r -> new LinkedList());
                subInstances.add(serviceInstance);
            }
        }
        for (Map.Entry<String, List<ServiceInstance>> entry : revisionToInstances.entrySet()) {
            String revision = entry.getKey();
            List<ServiceInstance> subInstances = entry.getValue();
            MetadataInfo metadataInfo = subInstances.stream().map(ServiceInstance::getServiceMetadata).filter(Objects::nonNull).filter(m -> revision.equals(m.getRevision())).findFirst().orElseGet(() -> this.serviceDiscovery.getRemoteMetadata(revision, subInstances));
            this.parseMetadata(revision, metadataInfo, localServiceToRevisions);
            for (ServiceInstance tmpInstance : subInstances) {
                MetadataInfo originMetadata = tmpInstance.getServiceMetadata();
                if (originMetadata != null && Objects.equals(originMetadata.getRevision(), metadataInfo.getRevision())) continue;
                tmpInstance.setServiceMetadata(metadataInfo);
            }
        }
        int emptyNum = this.hasEmptyMetadata(revisionToInstances);
        if (emptyNum != 0) {
            this.hasEmptyMetadata = true;
            if (this.retryPermission.tryAcquire()) {
                if (this.retryFuture != null && !this.retryFuture.isDone()) {
                    this.retryFuture.cancel(true);
                }
                try {
                    this.retryFuture = this.scheduler.schedule(new AddressRefreshRetryTask(this.retryPermission, event.getServiceName()), 10000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    logger.error("99-0", "unknown error in registry module", "", "Error submitting async retry task.");
                }
                logger.warn("99-0", "unknown error in registry module", "", "Address refresh try task submitted");
            }
            if (emptyNum == revisionToInstances.size()) {
                logger.error("1-17", "metadata Server failure", "", "Address refresh failed because of Metadata Server failure, wait for retry or new address refresh event.");
                return;
            }
        }
        this.hasEmptyMetadata = false;
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        HashMap<String, List<ProtocolServiceKeyWithUrls>> newServiceUrls = new HashMap<String, List<ProtocolServiceKeyWithUrls>>();
        for (Map.Entry entry : localServiceToRevisions.entrySet()) {
            MetadataInfo.ServiceInfo serviceInfo = (MetadataInfo.ServiceInfo)entry.getKey();
            Set revisions = (Set)entry.getValue();
            Map portToRevisions = hashMap.computeIfAbsent(serviceInfo.getProtocol(), k -> new HashMap());
            Map revisionsToUrls = portToRevisions.computeIfAbsent(serviceInfo.getPort(), k -> new HashMap());
            Object urls = revisionsToUrls.get(revisions);
            if (urls == null) {
                urls = this.getServiceUrlsCache(revisionToInstances, revisions, serviceInfo.getProtocol(), serviceInfo.getPort());
                revisionsToUrls.put(revisions, urls);
            }
            List list = newServiceUrls.computeIfAbsent(serviceInfo.getPath(), k -> new LinkedList());
            list.add(new ProtocolServiceKeyWithUrls(serviceInfo.getProtocolServiceKey(), (List)urls));
        }
        this.serviceUrls = newServiceUrls;
        this.notifyAddressChanged();
    }

    public synchronized void addListenerAndNotify(URL url, NotifyListener listener) {
        if (this.destroyed.get()) {
            return;
        }
        Set notifyListeners = this.listeners.computeIfAbsent(url.getServiceKey(), _k -> new ConcurrentHashSet());
        String protocol = listener.getConsumerUrl().getParameter("protocol", url.getProtocol());
        ProtocolServiceKey protocolServiceKey = new ProtocolServiceKey(url.getServiceInterface(), url.getVersion(), url.getGroup(), !"consumer".equals(protocol) ? protocol : null);
        NotifyListenerWithKey listenerWithKey = new NotifyListenerWithKey(protocolServiceKey, listener);
        notifyListeners.add(listenerWithKey);
        List<URL> urls = this.getAddresses(protocolServiceKey, listener.getConsumerUrl());
        if (CollectionUtils.isNotEmpty(urls)) {
            logger.info(String.format("Notify serviceKey: %s, listener: %s with %s urls on subscription", protocolServiceKey, listener, urls.size()));
            listener.notify(urls);
        }
    }

    public synchronized void removeListener(String serviceKey, NotifyListener notifyListener) {
        if (this.destroyed.get()) {
            return;
        }
        Set<NotifyListenerWithKey> notifyListeners = this.listeners.get(serviceKey);
        if (notifyListeners != null) {
            notifyListeners.removeIf(listener -> listener.getNotifyListener().equals(notifyListener));
            if (notifyListeners.size() == 0) {
                this.listeners.remove(serviceKey);
            }
        }
    }

    public boolean hasListeners() {
        return CollectionUtils.isNotEmptyMap(this.listeners);
    }

    public final Set<String> getServiceNames() {
        return this.serviceNames;
    }

    public Map<String, List<ServiceInstance>> getAllInstances() {
        return this.allInstances;
    }

    private boolean accept(ServiceInstancesChangedEvent event) {
        return this.serviceNames.contains(event.getServiceName());
    }

    protected boolean isRetryAndExpired(ServiceInstancesChangedEvent event) {
        if (event instanceof RetryServiceInstancesChangedEvent) {
            RetryServiceInstancesChangedEvent retryEvent = (RetryServiceInstancesChangedEvent)event;
            logger.warn("99-0", "unknown error in registry module", "", "Received address refresh retry event, " + retryEvent.getFailureRecordTime());
            if (retryEvent.getFailureRecordTime() < this.lastRefreshTime && !this.hasEmptyMetadata) {
                logger.warn("99-0", "unknown error in registry module", "", "Ignore retry event, event time: " + retryEvent.getFailureRecordTime() + ", last refresh time: " + this.lastRefreshTime);
                return true;
            }
            logger.warn("99-0", "unknown error in registry module", "", "Retrying address notification...");
        }
        return false;
    }

    private void refreshInstance(ServiceInstancesChangedEvent event) {
        if (event instanceof RetryServiceInstancesChangedEvent) {
            return;
        }
        String appName = event.getServiceName();
        List<ServiceInstance> appInstances = event.getServiceInstances();
        logger.info("Received instance notification, serviceName: " + appName + ", instances: " + appInstances.size());
        for (ServiceInstanceNotificationCustomizer serviceInstanceNotificationCustomizer : this.serviceInstanceNotificationCustomizers) {
            serviceInstanceNotificationCustomizer.customize(appInstances);
        }
        this.allInstances.put(appName, appInstances);
        this.lastRefreshTime = System.currentTimeMillis();
    }

    protected int hasEmptyMetadata(Map<String, List<ServiceInstance>> revisionToInstances) {
        if (revisionToInstances == null) {
            return 0;
        }
        StringBuilder builder = new StringBuilder();
        int emptyMetadataNum = 0;
        for (Map.Entry<String, List<ServiceInstance>> entry : revisionToInstances.entrySet()) {
            DefaultServiceInstance serviceInstance = (DefaultServiceInstance)entry.getValue().get(0);
            if (serviceInstance == null || serviceInstance.getServiceMetadata() == MetadataInfo.EMPTY) {
                ++emptyMetadataNum;
            }
            builder.append(entry.getKey());
            builder.append(' ');
        }
        if (emptyMetadataNum > 0) {
            builder.insert(0, emptyMetadataNum + "/" + revisionToInstances.size() + " revisions failed to get metadata from remote: ");
            logger.error("99-0", "unknown error in registry module", "", builder.toString());
        } else {
            builder.insert(0, revisionToInstances.size() + " unique working revisions: ");
            logger.info(builder.toString());
        }
        return emptyMetadataNum;
    }

    protected Map<MetadataInfo.ServiceInfo, Set<String>> parseMetadata(String revision, MetadataInfo metadata, Map<MetadataInfo.ServiceInfo, Set<String>> localServiceToRevisions) {
        Map<String, MetadataInfo.ServiceInfo> serviceInfos = metadata.getServices();
        for (Map.Entry<String, MetadataInfo.ServiceInfo> entry : serviceInfos.entrySet()) {
            Set set = localServiceToRevisions.computeIfAbsent(entry.getValue(), _k -> new TreeSet());
            set.add(revision);
        }
        return localServiceToRevisions;
    }

    protected Object getServiceUrlsCache(Map<String, List<ServiceInstance>> revisionToInstances, Set<String> revisions, String protocol, int port) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String r : revisions) {
            for (ServiceInstance i : revisionToInstances.get(r)) {
                DefaultServiceInstance.Endpoint endpoint;
                if (port > 0) {
                    if (i.getPort() == port) {
                        urls.add(i.toURL(protocol).setScopeModel(i.getApplicationModel()));
                        continue;
                    }
                    urls.add(((DefaultServiceInstance)i).copyFrom(port).toURL(protocol).setScopeModel(i.getApplicationModel()));
                    continue;
                }
                if (ServiceInstanceMetadataUtils.hasEndpoints(i) && (endpoint = ServiceInstanceMetadataUtils.getEndpoint(i, protocol)) != null && endpoint.getPort() != i.getPort()) {
                    urls.add(((DefaultServiceInstance)i).copyFrom(endpoint).toURL(endpoint.getProtocol()));
                    continue;
                }
                urls.add(i.toURL(protocol).setScopeModel(i.getApplicationModel()));
            }
        }
        return urls;
    }

    protected List<URL> getAddresses(ProtocolServiceKey protocolServiceKey, URL consumerURL) {
        List<ProtocolServiceKeyWithUrls> protocolServiceKeyWithUrlsList = this.serviceUrls.get(protocolServiceKey.getInterfaceName());
        ArrayList<URL> urls = new ArrayList<URL>();
        if (protocolServiceKeyWithUrlsList != null) {
            for (ProtocolServiceKeyWithUrls protocolServiceKeyWithUrls : protocolServiceKeyWithUrlsList) {
                if (!ProtocolServiceKey.Matcher.isMatch(protocolServiceKey, protocolServiceKeyWithUrls.getProtocolServiceKey())) continue;
                urls.addAll(protocolServiceKeyWithUrls.getUrls());
            }
        }
        if (this.serviceUrls.containsKey("*")) {
            for (ProtocolServiceKeyWithUrls protocolServiceKeyWithUrls : this.serviceUrls.get("*")) {
                urls.addAll(protocolServiceKeyWithUrls.getUrls());
            }
        }
        return urls;
    }

    protected void notifyAddressChanged() {
        ScopeBeanFactory beanFactory = this.applicationModel.getFrameworkModel().getBeanFactory();
        SimpleMetricsEventMulticaster eventMulticaster = beanFactory.getOrRegisterBean(SimpleMetricsEventMulticaster.class);
        TimePair timePair = TimePair.start();
        eventMulticaster.publishEvent(new RegistryEvent.MetricsNotifyEvent(this.applicationModel, timePair, null));
        HashMap<String, Integer> lastNumMap = new HashMap<String, Integer>();
        this.listeners.forEach((serviceKey, listenerSet) -> {
            for (NotifyListenerWithKey listenerWithKey : listenerSet) {
                NotifyListener notifyListener = listenerWithKey.getNotifyListener();
                List<URL> urls = this.toUrlsWithEmpty(this.getAddresses(listenerWithKey.getProtocolServiceKey(), notifyListener.getConsumerUrl()));
                logger.info("Notify service " + listenerWithKey.getProtocolServiceKey() + " with urls " + urls.size());
                notifyListener.notify(urls);
                lastNumMap.put((String)serviceKey, urls.size());
            }
        });
        eventMulticaster.publishFinishEvent(new RegistryEvent.MetricsNotifyEvent(this.applicationModel, timePair, lastNumMap));
    }

    protected List<URL> toUrlsWithEmpty(List<URL> urls) {
        boolean emptyProtectionEnabled = this.serviceDiscovery.getUrl().getParameter("enable-empty-protection", false);
        if (!emptyProtectionEnabled && urls == null) {
            urls = new ArrayList<URL>();
        } else if (emptyProtectionEnabled && urls == null) {
            urls = Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(urls) && !emptyProtectionEnabled) {
            ServiceConfigURL empty = URLBuilder.from(this.serviceDiscovery.getUrl()).setProtocol("empty").build();
            urls.add(empty);
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            logger.info("Destroying instance listener of  " + this.getServiceNames());
            this.serviceDiscovery.removeServiceInstancesChangedListener(this);
            ServiceInstancesChangedListener serviceInstancesChangedListener = this;
            synchronized (serviceInstancesChangedListener) {
                this.allInstances.clear();
                this.serviceUrls.clear();
                this.listeners.clear();
                if (this.retryFuture != null && !this.retryFuture.isDone()) {
                    this.retryFuture.cancel(true);
                }
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceInstancesChangedListener)) {
            return false;
        }
        ServiceInstancesChangedListener that = (ServiceInstancesChangedListener)o;
        return Objects.equals(this.getServiceNames(), that.getServiceNames()) && Objects.equals(this.listeners, that.listeners);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.getServiceNames(), this.listeners);
    }

    public static class ProtocolServiceKeyWithUrls {
        private final ProtocolServiceKey protocolServiceKey;
        private final List<URL> urls;

        public ProtocolServiceKeyWithUrls(ProtocolServiceKey protocolServiceKey, List<URL> urls) {
            this.protocolServiceKey = protocolServiceKey;
            this.urls = urls;
        }

        public ProtocolServiceKey getProtocolServiceKey() {
            return this.protocolServiceKey;
        }

        public List<URL> getUrls() {
            return this.urls;
        }
    }

    public static class NotifyListenerWithKey {
        private final ProtocolServiceKey protocolServiceKey;
        private final NotifyListener notifyListener;

        public NotifyListenerWithKey(ProtocolServiceKey protocolServiceKey, NotifyListener notifyListener) {
            this.protocolServiceKey = protocolServiceKey;
            this.notifyListener = notifyListener;
        }

        public ProtocolServiceKey getProtocolServiceKey() {
            return this.protocolServiceKey;
        }

        public NotifyListener getNotifyListener() {
            return this.notifyListener;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotifyListenerWithKey that = (NotifyListenerWithKey)o;
            return Objects.equals(this.protocolServiceKey, that.protocolServiceKey) && Objects.equals(this.notifyListener, that.notifyListener);
        }

        public int hashCode() {
            return Objects.hash(this.protocolServiceKey, this.notifyListener);
        }
    }

    protected class AddressRefreshRetryTask
    implements Runnable {
        private final RetryServiceInstancesChangedEvent retryEvent;
        private final Semaphore retryPermission;

        public AddressRefreshRetryTask(Semaphore semaphore, String serviceName) {
            this.retryEvent = new RetryServiceInstancesChangedEvent(serviceName);
            this.retryPermission = semaphore;
        }

        @Override
        public void run() {
            this.retryPermission.release();
            ServiceInstancesChangedListener.this.onEvent(this.retryEvent);
        }
    }
}

