/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.context.ModuleConfigManager;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.qos.permission.PermissionLevel;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;

@Cmd(name="getConfig", summary="Get current running config.", example={"getConfig ReferenceConfig com.example.DemoService", "getConfig ApplicationConfig"}, requiredPermissionLevel=PermissionLevel.PRIVATE)
public class GetConfig
implements BaseCommand {
    private final FrameworkModel frameworkModel;

    public GetConfig(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        boolean http = commandContext.isHttp();
        StringBuilder plainOutput = new StringBuilder();
        HashMap<String, Object> frameworkMap = new HashMap<String, Object>();
        this.appendFrameworkConfig(args, plainOutput, frameworkMap);
        if (http) {
            return JsonUtils.getJson().toJson(frameworkMap);
        }
        return plainOutput.toString();
    }

    private void appendFrameworkConfig(String[] args, StringBuilder plainOutput, Map<String, Object> frameworkMap) {
        for (ApplicationModel applicationModel : this.frameworkModel.getApplicationModels()) {
            HashMap<String, Object> applicationMap = new HashMap<String, Object>();
            frameworkMap.put(applicationModel.getDesc(), applicationMap);
            plainOutput.append("ApplicationModel: ").append(applicationModel.getDesc()).append("\n");
            ConfigManager configManager = applicationModel.getApplicationConfigManager();
            GetConfig.appendApplicationConfigs(args, plainOutput, applicationModel, applicationMap, configManager);
        }
    }

    private static void appendApplicationConfigs(String[] args, StringBuilder plainOutput, ApplicationModel applicationModel, Map<String, Object> applicationMap, ConfigManager configManager) {
        Optional<ApplicationConfig> applicationConfig = configManager.getApplication();
        applicationConfig.ifPresent(config -> GetConfig.appendConfig("ApplicationConfig", config.getName(), config, plainOutput, applicationMap, args));
        for (ProtocolConfig protocol : configManager.getProtocols()) {
            GetConfig.appendConfigs("ProtocolConfig", protocol.getName(), protocol, plainOutput, applicationMap, args);
        }
        for (RegistryConfig registry : configManager.getRegistries()) {
            GetConfig.appendConfigs("RegistryConfig", registry.getId(), registry, plainOutput, applicationMap, args);
        }
        for (MetadataReportConfig metadataConfig : configManager.getMetadataConfigs()) {
            GetConfig.appendConfigs("MetadataReportConfig", metadataConfig.getId(), metadataConfig, plainOutput, applicationMap, args);
        }
        for (ConfigCenterConfig configCenter : configManager.getConfigCenters()) {
            GetConfig.appendConfigs("ConfigCenterConfig", configCenter.getId(), configCenter, plainOutput, applicationMap, args);
        }
        Optional<MetricsConfig> metricsConfig = configManager.getMetrics();
        metricsConfig.ifPresent(config -> GetConfig.appendConfig("MetricsConfig", config.getId(), config, plainOutput, applicationMap, args));
        Optional<MonitorConfig> monitorConfig = configManager.getMonitor();
        monitorConfig.ifPresent(config -> GetConfig.appendConfig("MonitorConfig", config.getId(), config, plainOutput, applicationMap, args));
        Optional<SslConfig> sslConfig = configManager.getSsl();
        sslConfig.ifPresent(config -> GetConfig.appendConfig("SslConfig", config.getId(), config, plainOutput, applicationMap, args));
        for (ModuleModel moduleModel : applicationModel.getModuleModels()) {
            HashMap<String, Object> moduleMap = new HashMap<String, Object>();
            applicationMap.put(moduleModel.getDesc(), moduleMap);
            plainOutput.append("ModuleModel: ").append(moduleModel.getDesc()).append("\n");
            ModuleConfigManager moduleConfigManager = moduleModel.getConfigManager();
            GetConfig.appendModuleConfigs(args, plainOutput, moduleMap, moduleConfigManager);
        }
    }

    private static void appendModuleConfigs(String[] args, StringBuilder plainOutput, Map<String, Object> moduleMap, ModuleConfigManager moduleConfigManager) {
        for (ProviderConfig provider : moduleConfigManager.getProviders()) {
            GetConfig.appendConfigs("ProviderConfig", provider.getId(), provider, plainOutput, moduleMap, args);
        }
        for (ConsumerConfig consumer : moduleConfigManager.getConsumers()) {
            GetConfig.appendConfigs("ConsumerConfig", consumer.getId(), consumer, plainOutput, moduleMap, args);
        }
        Optional<ModuleConfig> moduleConfig = moduleConfigManager.getModule();
        moduleConfig.ifPresent(config -> GetConfig.appendConfig("ModuleConfig", config.getId(), config, plainOutput, moduleMap, args));
        for (ServiceConfigBase serviceConfigBase : moduleConfigManager.getServices()) {
            GetConfig.appendConfigs("ServiceConfig", serviceConfigBase.getUniqueServiceName(), serviceConfigBase, plainOutput, moduleMap, args);
        }
        for (ReferenceConfigBase referenceConfigBase : moduleConfigManager.getReferences()) {
            GetConfig.appendConfigs("ReferenceConfig", referenceConfigBase.getUniqueServiceName(), referenceConfigBase, plainOutput, moduleMap, args);
        }
    }

    private static void appendConfigs(String type, String id, Object config, StringBuilder plainOutput, Map<String, Object> map, String[] args) {
        if (!GetConfig.isMatch(type, id, args)) {
            return;
        }
        plainOutput.append(type).append(": ").append(id).append("\n").append(config).append("\n\n");
        Map typeMap = (Map)map.computeIfAbsent(type, k -> new HashMap());
        typeMap.put(id, config);
    }

    private static void appendConfig(String type, String id, Object config, StringBuilder plainOutput, Map<String, Object> map, String[] args) {
        if (!GetConfig.isMatch(type, id, args)) {
            return;
        }
        plainOutput.append(type).append(": ").append(id).append("\n").append(config).append("\n\n");
        map.put(type, config);
    }

    private static boolean isMatch(String type, String id, String[] args) {
        if (args == null) {
            return true;
        }
        switch (args.length) {
            case 1: {
                if (Objects.equals(args[0], type)) break;
                return false;
            }
            case 2: {
                if (Objects.equals(args[0], type) && Objects.equals(args[1], id)) break;
                return false;
            }
        }
        return true;
    }
}

