/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.event;

import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.listener.MetricsLifeListener;
import org.apache.dubbo.metrics.registry.collector.stat.RegistryStatComposite;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetricsRegisterListener
implements MetricsLifeListener<RegistryEvent.MetricsRegisterEvent> {
    @Override
    public boolean isSupport(MetricsEvent event) {
        return event instanceof RegistryEvent.MetricsRegisterEvent;
    }

    @Override
    public void onEvent(RegistryEvent.MetricsRegisterEvent event) {
        if (!event.isAvailable()) {
            return;
        }
        event.getCollector().increment(((ApplicationModel)event.getSource()).getApplicationName(), RegistryEvent.Type.R_TOTAL);
    }

    @Override
    public void onEventFinish(RegistryEvent.MetricsRegisterEvent event) {
        event.getCollector().increment(((ApplicationModel)event.getSource()).getApplicationName(), RegistryEvent.Type.R_SUCCEED);
        event.getCollector().addRT(((ApplicationModel)event.getSource()).getApplicationName(), RegistryStatComposite.OP_TYPE_REGISTER, event.getTimePair().calc());
    }

    @Override
    public void onEventError(RegistryEvent.MetricsRegisterEvent event) {
        event.getCollector().increment(((ApplicationModel)event.getSource()).getApplicationName(), RegistryEvent.Type.R_FAILED);
        event.getCollector().addRT(((ApplicationModel)event.getSource()).getApplicationName(), RegistryStatComposite.OP_TYPE_REGISTER, event.getTimePair().calc());
    }
}

