/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.metrics.collector.ApplicationMetricsCollector;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventMulticaster;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.registry.collector.stat.RegistryStatComposite;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;
import org.apache.dubbo.metrics.registry.event.RegistryMetricsEventMulticaster;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class RegistryMetricsCollector
implements ApplicationMetricsCollector<RegistryEvent.Type, RegistryEvent> {
    private Boolean collectEnabled = null;
    private final RegistryStatComposite stats = new RegistryStatComposite();
    private final MetricsEventMulticaster registryMulticaster = new RegistryMetricsEventMulticaster();
    private final ApplicationModel applicationModel;

    public RegistryMetricsCollector(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        if (collectEnabled != null) {
            this.collectEnabled = collectEnabled;
        }
    }

    @Override
    public boolean isCollectEnabled() {
        if (this.collectEnabled == null) {
            ConfigManager configManager = this.applicationModel.getApplicationConfigManager();
            configManager.getMetrics().ifPresent(metricsConfig -> this.setCollectEnabled(metricsConfig.getEnableRegistryMetrics()));
        }
        return Optional.ofNullable(this.collectEnabled).orElse(false);
    }

    public void setNum(RegistryEvent.Type registryType, String applicationName, Map<String, Integer> lastNumMap) {
        lastNumMap.forEach((serviceKey, num) -> this.stats.setServiceKey(registryType, applicationName, (String)serviceKey, (int)num));
    }

    public void setNum(RegistryEvent.Type registryType, String applicationName, Integer num) {
        this.stats.setApplicationKey(registryType, applicationName, num);
    }

    @Override
    public void increment(String applicationName, RegistryEvent.Type registryType) {
        this.stats.increment(registryType, applicationName);
    }

    @Override
    public void addRT(String applicationName, String registryOpType, Long responseTime) {
        this.stats.calcRt(applicationName, registryOpType, responseTime);
    }

    @Override
    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        if (!this.isCollectEnabled()) {
            return list;
        }
        list.addAll(this.stats.exportNumMetrics());
        list.addAll(this.stats.exportRtMetrics());
        list.addAll(this.stats.exportSkMetrics());
        return list;
    }

    @Override
    public boolean isSupport(MetricsEvent event) {
        return event instanceof RegistryEvent;
    }

    @Override
    public void onEvent(RegistryEvent event) {
        this.registryMulticaster.publishEvent(event);
    }

    @Override
    public void onEventFinish(RegistryEvent event) {
        this.registryMulticaster.publishFinishEvent(event);
    }

    @Override
    public void onEventError(RegistryEvent event) {
        this.registryMulticaster.publishErrorEvent(event);
    }
}

