/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.metadata.event;

import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.listener.MetricsLifeListener;
import org.apache.dubbo.metrics.metadata.collector.stat.MetadataStatComposite;
import org.apache.dubbo.metrics.metadata.event.MetadataEvent;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetricsSubscribeListener
implements MetricsLifeListener<MetadataEvent.SubscribeEvent> {
    @Override
    public boolean isSupport(MetricsEvent event) {
        return event instanceof MetadataEvent.SubscribeEvent && ((MetadataEvent)event).isAvailable();
    }

    @Override
    public void onEvent(MetadataEvent.SubscribeEvent event) {
        event.getCollector().increment(((ApplicationModel)event.getSource()).getApplicationName(), MetadataEvent.Type.S_TOTAL);
    }

    @Override
    public void onEventFinish(MetadataEvent.SubscribeEvent event) {
        event.getCollector().increment(((ApplicationModel)event.getSource()).getApplicationName(), MetadataEvent.Type.S_SUCCEED);
        event.getCollector().addRT(((ApplicationModel)event.getSource()).getApplicationName(), MetadataStatComposite.OP_TYPE_SUBSCRIBE, event.getTimePair().calc());
    }

    @Override
    public void onEventError(MetadataEvent.SubscribeEvent event) {
        event.getCollector().increment(((ApplicationModel)event.getSource()).getApplicationName(), MetadataEvent.Type.S_FAILED);
        event.getCollector().addRT(((ApplicationModel)event.getSource()).getApplicationName(), MetadataStatComposite.OP_TYPE_SUBSCRIBE, event.getTimePair().calc());
    }
}

