/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.metadata.event;

import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.listener.MetricsLifeListener;
import org.apache.dubbo.metrics.metadata.collector.stat.MetadataStatComposite;
import org.apache.dubbo.metrics.metadata.event.MetadataEvent;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetricsPushListener
implements MetricsLifeListener<MetadataEvent.PushEvent> {
    @Override
    public boolean isSupport(MetricsEvent event) {
        return event instanceof MetadataEvent.PushEvent && ((MetadataEvent)event).isAvailable();
    }

    @Override
    public void onEvent(MetadataEvent.PushEvent event) {
        event.getCollector().increment(((ApplicationModel)event.getSource()).getApplicationName(), MetadataEvent.Type.P_TOTAL);
    }

    @Override
    public void onEventFinish(MetadataEvent.PushEvent event) {
        event.getCollector().increment(((ApplicationModel)event.getSource()).getApplicationName(), MetadataEvent.Type.P_SUCCEED);
        event.getCollector().addRT(((ApplicationModel)event.getSource()).getApplicationName(), MetadataStatComposite.OP_TYPE_PUSH, event.getTimePair().calc());
    }

    @Override
    public void onEventError(MetadataEvent.PushEvent event) {
        event.getCollector().increment(((ApplicationModel)event.getSource()).getApplicationName(), MetadataEvent.Type.P_FAILED);
        event.getCollector().addRT(((ApplicationModel)event.getSource()).getApplicationName(), MetadataStatComposite.OP_TYPE_PUSH, event.getTimePair().calc());
    }
}

