/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.metadata.event;

import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.TimeCounter;
import org.apache.dubbo.metrics.metadata.collector.MetadataMetricsCollector;
import org.apache.dubbo.metrics.model.MetricsKey;
import org.apache.dubbo.metrics.model.TimePair;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataEvent
extends MetricsEvent
implements TimeCounter {
    private final TimePair timePair;
    private final MetadataMetricsCollector collector;
    private final boolean available;

    public MetadataEvent(ApplicationModel applicationModel, TimePair timePair) {
        super(applicationModel);
        this.timePair = timePair;
        this.collector = applicationModel.getBeanFactory().getBean(MetadataMetricsCollector.class);
        this.available = this.collector != null && this.collector.isCollectEnabled();
    }

    @Override
    public ApplicationModel getSource() {
        return (ApplicationModel)this.source;
    }

    public MetadataMetricsCollector getCollector() {
        return this.collector;
    }

    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public TimePair getTimePair() {
        return this.timePair;
    }

    public static class SubscribeEvent
    extends MetadataEvent {
        public SubscribeEvent(ApplicationModel applicationModel, TimePair timePair) {
            super(applicationModel, timePair);
        }
    }

    public static class PushEvent
    extends MetadataEvent {
        public PushEvent(ApplicationModel applicationModel, TimePair timePair) {
            super(applicationModel, timePair);
        }
    }

    public static enum Type {
        P_TOTAL(MetricsKey.METADATA_PUSH_METRIC_NUM),
        P_SUCCEED(MetricsKey.METADATA_PUSH_METRIC_NUM_SUCCEED),
        P_FAILED(MetricsKey.METADATA_PUSH_METRIC_NUM_FAILED),
        S_TOTAL(MetricsKey.METADATA_SUBSCRIBE_METRIC_NUM),
        S_SUCCEED(MetricsKey.METADATA_SUBSCRIBE_METRIC_NUM_SUCCEED),
        S_FAILED(MetricsKey.METADATA_SUBSCRIBE_METRIC_NUM_FAILED);

        private final MetricsKey metricsKey;
        private final boolean isIncrement;

        private Type(MetricsKey metricsKey) {
            this(metricsKey, true);
        }

        private Type(MetricsKey metricsKey, boolean isIncrement) {
            this.metricsKey = metricsKey;
            this.isIncrement = isIncrement;
        }

        public MetricsKey getMetricsKey() {
            return this.metricsKey;
        }

        public boolean isIncrement() {
            return this.isIncrement;
        }
    }
}

