/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.metadata.collector.stat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.metrics.metadata.event.MetadataEvent;
import org.apache.dubbo.metrics.model.ApplicationMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsKey;
import org.apache.dubbo.metrics.model.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.container.AtomicLongContainer;
import org.apache.dubbo.metrics.model.container.LongAccumulatorContainer;
import org.apache.dubbo.metrics.model.container.LongContainer;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.report.MetricsExport;

public class MetadataStatComposite
implements MetricsExport {
    public Map<MetadataEvent.Type, Map<String, AtomicLong>> numStats = new ConcurrentHashMap<MetadataEvent.Type, Map<String, AtomicLong>>();
    public List<LongContainer<? extends Number>> rtStats = new ArrayList<LongContainer<? extends Number>>();
    public static String OP_TYPE_PUSH = "push";
    public static String OP_TYPE_SUBSCRIBE = "subscribe";

    public MetadataStatComposite() {
        for (MetadataEvent.Type type : MetadataEvent.Type.values()) {
            this.numStats.put(type, new ConcurrentHashMap());
        }
        this.rtStats.addAll(this.initStats(OP_TYPE_PUSH));
        this.rtStats.addAll(this.initStats(OP_TYPE_SUBSCRIBE));
    }

    private List<LongContainer<? extends Number>> initStats(String registryOpType) {
        ArrayList<LongContainer<? extends Number>> singleRtStats = new ArrayList<LongContainer<? extends Number>>();
        singleRtStats.add(new AtomicLongContainer(new MetricsKeyWrapper(registryOpType, MetricsKey.METRIC_RT_LAST)));
        singleRtStats.add(new LongAccumulatorContainer(new MetricsKeyWrapper(registryOpType, MetricsKey.METRIC_RT_MIN), new LongAccumulator(Long::min, Long.MAX_VALUE)));
        singleRtStats.add(new LongAccumulatorContainer(new MetricsKeyWrapper(registryOpType, MetricsKey.METRIC_RT_MAX), new LongAccumulator(Long::max, Long.MIN_VALUE)));
        singleRtStats.add(new AtomicLongContainer(new MetricsKeyWrapper(registryOpType, MetricsKey.METRIC_RT_SUM), (responseTime, longAccumulator) -> longAccumulator.addAndGet((long)responseTime)));
        AtomicLongContainer avgContainer = new AtomicLongContainer(new MetricsKeyWrapper(registryOpType, MetricsKey.METRIC_RT_AVG), (k, v) -> v.incrementAndGet());
        avgContainer.setValueSupplier(applicationName -> {
            LongContainer totalContainer = this.rtStats.stream().filter(longContainer -> longContainer.isKeyWrapper(MetricsKey.METRIC_RT_SUM, registryOpType)).findFirst().get();
            AtomicLong totalRtTimes = (AtomicLong)avgContainer.get(applicationName);
            AtomicLong totalRtSum = (AtomicLong)totalContainer.get(applicationName);
            return totalRtSum.get() / totalRtTimes.get();
        });
        singleRtStats.add(avgContainer);
        return singleRtStats;
    }

    public void increment(MetadataEvent.Type type, String applicationName) {
        if (!this.numStats.containsKey((Object)type)) {
            return;
        }
        this.numStats.get((Object)type).computeIfAbsent(applicationName, k -> new AtomicLong(0L)).incrementAndGet();
    }

    public void calcRt(String applicationName, String registryOpType, Long responseTime) {
        for (LongContainer container : this.rtStats.stream().filter(longContainer -> longContainer.specifyType(registryOpType)).collect(Collectors.toList())) {
            Number current = (Number)ConcurrentHashMapUtils.computeIfAbsent(container, applicationName, container.getInitFunc());
            container.getConsumerFunc().accept(responseTime, current);
        }
    }

    @Override
    public List<GaugeMetricSample> exportNumMetrics() {
        ArrayList<GaugeMetricSample> list = new ArrayList<GaugeMetricSample>();
        for (MetadataEvent.Type type : this.numStats.keySet()) {
            Map<String, AtomicLong> stringAtomicLongMap = this.numStats.get((Object)type);
            for (String applicationName : stringAtomicLongMap.keySet()) {
                list.add(this.convertToSample(applicationName, type, MetricsCategory.REGISTRY, stringAtomicLongMap.get(applicationName)));
            }
        }
        return list;
    }

    @Override
    public List<GaugeMetricSample> exportRtMetrics() {
        ArrayList<GaugeMetricSample> list = new ArrayList<GaugeMetricSample>();
        for (LongContainer<? extends Number> rtContainer : this.rtStats) {
            MetricsKeyWrapper metricsKeyWrapper = rtContainer.getMetricsKeyWrapper();
            for (Map.Entry entry : rtContainer.entrySet()) {
                list.add(new GaugeMetricSample<Map.Entry>(metricsKeyWrapper.targetKey(), metricsKeyWrapper.targetDesc(), ApplicationMetric.getTagsByName((String)entry.getKey()), MetricsCategory.RT, entry, value -> rtContainer.getValueSupplier().apply((String)value.getKey()).longValue()));
            }
        }
        return list;
    }

    public GaugeMetricSample convertToSample(String applicationName, MetadataEvent.Type type, MetricsCategory category, AtomicLong targetNumber) {
        return new GaugeMetricSample<AtomicLong>(type.getMetricsKey(), ApplicationMetric.getTagsByName(applicationName), category, targetNumber, AtomicLong::get);
    }
}

