/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.metadata.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.metrics.collector.ApplicationMetricsCollector;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventMulticaster;
import org.apache.dubbo.metrics.metadata.collector.stat.MetadataStatComposite;
import org.apache.dubbo.metrics.metadata.event.MetadataEvent;
import org.apache.dubbo.metrics.metadata.event.MetadataMetricsEventMulticaster;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class MetadataMetricsCollector
implements ApplicationMetricsCollector<MetadataEvent.Type, MetadataEvent> {
    private Boolean collectEnabled = null;
    private final MetadataStatComposite stats = new MetadataStatComposite();
    private final MetricsEventMulticaster metadataEventMulticaster = new MetadataMetricsEventMulticaster();
    private final ApplicationModel applicationModel;

    public MetadataMetricsCollector(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        if (collectEnabled != null) {
            this.collectEnabled = collectEnabled;
        }
    }

    @Override
    public boolean isCollectEnabled() {
        if (this.collectEnabled == null) {
            ConfigManager configManager = this.applicationModel.getApplicationConfigManager();
            configManager.getMetrics().ifPresent(metricsConfig -> this.setCollectEnabled(metricsConfig.getEnableMetadataMetrics()));
        }
        return Optional.ofNullable(this.collectEnabled).orElse(false);
    }

    @Override
    public void increment(String applicationName, MetadataEvent.Type registryType) {
        this.stats.increment(registryType, applicationName);
    }

    @Override
    public void addRT(String applicationName, String registryOpType, Long responseTime) {
        this.stats.calcRt(applicationName, registryOpType, responseTime);
    }

    @Override
    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        if (!this.isCollectEnabled()) {
            return list;
        }
        list.addAll(this.stats.exportNumMetrics());
        list.addAll(this.stats.exportRtMetrics());
        return list;
    }

    @Override
    public boolean isSupport(MetricsEvent event) {
        return event instanceof MetadataEvent;
    }

    @Override
    public void onEvent(MetadataEvent event) {
        this.metadataEventMulticaster.publishEvent(event);
    }

    @Override
    public void onEventFinish(MetadataEvent event) {
        this.metadataEventMulticaster.publishFinishEvent(event);
    }

    @Override
    public void onEventError(MetadataEvent event) {
        this.metadataEventMulticaster.publishErrorEvent(event);
    }
}

