/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.store.DataStore;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.sample.MetricsSampler;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsKey;
import org.apache.dubbo.metrics.model.ThreadPoolMetric;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ThreadPoolMetricsSampler
implements MetricsSampler {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ThreadPoolMetricsSampler.class);
    private final DefaultMetricsCollector collector;
    private FrameworkExecutorRepository frameworkExecutorRepository;
    private DataStore dataStore;
    private final Map<String, ThreadPoolExecutor> sampleThreadPoolExecutor = new ConcurrentHashMap<String, ThreadPoolExecutor>();

    public ThreadPoolMetricsSampler(DefaultMetricsCollector collector) {
        this.collector = collector;
    }

    public void addExecutors(String name, ExecutorService executorService) {
        Optional.ofNullable(executorService).filter(Objects::nonNull).filter(e -> e instanceof ThreadPoolExecutor).map(e -> (ThreadPoolExecutor)e).ifPresent(threadPoolExecutor -> this.sampleThreadPoolExecutor.put(name, (ThreadPoolExecutor)threadPoolExecutor));
    }

    @Override
    public List<MetricSample> sample() {
        ArrayList<MetricSample> metricSamples = new ArrayList<MetricSample>();
        this.sampleThreadPoolExecutor.forEach((name, executor) -> metricSamples.addAll(this.createMetricsSample((String)name, (ThreadPoolExecutor)executor)));
        return metricSamples;
    }

    private List<MetricSample> createMetricsSample(String name, ThreadPoolExecutor executor) {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        ThreadPoolMetric poolMetrics = new ThreadPoolMetric(this.collector.getApplicationName(), name, executor);
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_CORE_SIZE, poolMetrics.getTags(), MetricsCategory.THREAD_POOL, poolMetrics, ThreadPoolMetric::getCorePoolSize));
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_LARGEST_SIZE, poolMetrics.getTags(), MetricsCategory.THREAD_POOL, poolMetrics, ThreadPoolMetric::getLargestPoolSize));
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_MAX_SIZE, poolMetrics.getTags(), MetricsCategory.THREAD_POOL, poolMetrics, ThreadPoolMetric::getMaximumPoolSize));
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_ACTIVE_SIZE, poolMetrics.getTags(), MetricsCategory.THREAD_POOL, poolMetrics, ThreadPoolMetric::getActiveCount));
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_THREAD_COUNT, poolMetrics.getTags(), MetricsCategory.THREAD_POOL, poolMetrics, ThreadPoolMetric::getPoolSize));
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_QUEUE_SIZE, poolMetrics.getTags(), MetricsCategory.THREAD_POOL, poolMetrics, ThreadPoolMetric::getQueueSize));
        return list;
    }

    public void registryDefaultSampleThreadPoolExecutor() {
        ApplicationModel applicationModel = this.collector.getApplicationModel();
        if (applicationModel == null) {
            return;
        }
        try {
            if (this.frameworkExecutorRepository == null) {
                this.frameworkExecutorRepository = this.collector.getApplicationModel().getBeanFactory().getBean(FrameworkExecutorRepository.class);
            }
        }
        catch (Exception ex) {
            this.logger.warn("0-13", "", "", "ThreadPoolMetricsSampler! frameworkExecutorRepository non-init");
        }
        if (this.dataStore == null) {
            this.dataStore = this.collector.getApplicationModel().getExtensionLoader(DataStore.class).getDefaultExtension();
        }
        if (this.dataStore != null) {
            ExecutorService executor;
            Map<String, Object> executors = this.dataStore.get(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY);
            for (Map.Entry<String, Object> entry : executors.entrySet()) {
                executor = (ExecutorService)entry.getValue();
                if (!(executor instanceof ThreadPoolExecutor)) continue;
                this.addExecutors("DubboServerHandler-" + entry.getKey(), executor);
            }
            executors = this.dataStore.get("CONSUMER_SHARED_SERVICE_EXECUTOR");
            for (Map.Entry<String, Object> entry : executors.entrySet()) {
                executor = (ExecutorService)entry.getValue();
                if (!(executor instanceof ThreadPoolExecutor)) continue;
                this.addExecutors("DubboClientHandler-" + entry.getKey(), executor);
            }
        }
        if (this.frameworkExecutorRepository != null) {
            this.addExecutors("sharedExecutor", this.frameworkExecutorRepository.getSharedExecutor());
        }
    }
}

