/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToDoubleFunction;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampleConfigurer;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampler;
import org.apache.dubbo.metrics.collector.sample.SimpleMetricsCountSampler;
import org.apache.dubbo.metrics.event.MethodEvent;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.RTEvent;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.metrics.model.Metric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.Invocation;

public class MethodMetricsSampler
extends SimpleMetricsCountSampler<Invocation, String, MethodMetric> {
    private final DefaultMetricsCollector collector;

    public MethodMetricsSampler(DefaultMetricsCollector collector) {
        this.collector = collector;
    }

    @Override
    protected void countConfigure(MetricsCountSampleConfigurer<Invocation, String, MethodMetric> sampleConfigure) {
        sampleConfigure.configureMetrics(configure -> new MethodMetric(this.collector.getApplicationName(), (Invocation)configure.getSource()));
        sampleConfigure.configureEventHandler(configure -> this.collector.getEventMulticaster().publishEvent(new MethodEvent(configure.getMetric(), (String)configure.getMetricName())));
    }

    @Override
    public void rtConfigure(MetricsCountSampleConfigurer<Invocation, String, MethodMetric> sampleConfigure) {
        sampleConfigure.configureMetrics(configure -> new MethodMetric(this.collector.getApplicationName(), (Invocation)configure.getSource()));
        sampleConfigure.configureEventHandler(configure -> this.collector.getEventMulticaster().publishEvent(new RTEvent(configure.getMetric(), configure.getRt())));
    }

    @Override
    public List<MetricSample> sample() {
        ArrayList<MetricSample> metricSamples = new ArrayList<MetricSample>();
        this.collect(metricSamples);
        metricSamples.addAll(this.collectRT(new MetricsCountSampler.MetricSampleFactory<MethodMetric, GaugeMetricSample<?>>(){

            @Override
            public <T> GaugeMetricSample<?> newInstance(MetricsKey key, MethodMetric metric, T value, ToDoubleFunction<T> apply) {
                return MethodMetricsSampler.this.getGaugeMetricSample(key, metric, MetricsCategory.RT, value, apply);
            }
        }));
        return metricSamples;
    }

    private void collect(List<MetricSample> list) {
        this.collectBySide(list, "provider");
        this.collectBySide(list, "consumer");
    }

    private void collectBySide(List<MetricSample> list, String side) {
        this.count(list, MetricsEvent.Type.TOTAL.getNameByType(side), MetricsKey.METRIC_REQUESTS);
        this.count(list, MetricsEvent.Type.SUCCEED.getNameByType(side), MetricsKey.METRIC_REQUESTS_SUCCEED);
        this.count(list, MetricsEvent.Type.UNKNOWN_FAILED.getNameByType(side), MetricsKey.METRIC_REQUESTS_FAILED);
        this.count(list, MetricsEvent.Type.PROCESSING.getNameByType(side), MetricsKey.METRIC_REQUESTS_PROCESSING);
        this.count(list, MetricsEvent.Type.BUSINESS_FAILED.getNameByType(side), MetricsKey.METRIC_REQUEST_BUSINESS_FAILED);
        this.count(list, MetricsEvent.Type.REQUEST_TIMEOUT.getNameByType(side), MetricsKey.METRIC_REQUESTS_TIMEOUT);
        this.count(list, MetricsEvent.Type.REQUEST_LIMIT.getNameByType(side), MetricsKey.METRIC_REQUESTS_LIMIT);
        this.count(list, MetricsEvent.Type.TOTAL_FAILED.getNameByType(side), MetricsKey.METRIC_REQUESTS_TOTAL_FAILED);
        this.count(list, MetricsEvent.Type.NETWORK_EXCEPTION.getNameByType(side), MetricsKey.METRIC_REQUESTS_NETWORK_FAILED);
        this.count(list, MetricsEvent.Type.SERVICE_UNAVAILABLE.getNameByType(side), MetricsKey.METRIC_REQUESTS_SERVICE_UNAVAILABLE_FAILED);
        this.count(list, MetricsEvent.Type.CODEC_EXCEPTION.getNameByType(side), MetricsKey.METRIC_REQUESTS_CODEC_FAILED);
    }

    private <T> GaugeMetricSample<T> getGaugeMetricSample(MetricsKey metricsKey, MethodMetric methodMetric, MetricsCategory metricsCategory, T value, ToDoubleFunction<T> apply) {
        return new GaugeMetricSample<T>(metricsKey.getNameByType(methodMetric.getSide()), metricsKey.getDescription(), methodMetric.getTags(), metricsCategory, value, apply);
    }

    private <T extends Metric> void count(List<MetricSample> list, String eventType, MetricsKey metricsKey) {
        this.getCount(eventType).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> list.add(this.getGaugeMetricSample(metricsKey, (MethodMetric)k, MetricsCategory.REQUESTS, (Object)v, AtomicLong::get))));
    }
}

