/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.metrics.collector.MetricsCollector;
import org.apache.dubbo.metrics.collector.sample.MethodMetricsSampler;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampleConfigurer;
import org.apache.dubbo.metrics.collector.sample.MetricsSampler;
import org.apache.dubbo.metrics.collector.sample.SimpleMetricsCountSampler;
import org.apache.dubbo.metrics.collector.sample.ThreadPoolMetricsSampler;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.SimpleMetricsEventMulticaster;
import org.apache.dubbo.metrics.listener.MetricsListener;
import org.apache.dubbo.metrics.model.ApplicationMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DefaultMetricsCollector
implements MetricsCollector {
    private boolean collectEnabled = false;
    private final SimpleMetricsEventMulticaster eventMulticaster;
    private final MethodMetricsSampler methodSampler = new MethodMetricsSampler(this);
    private final ThreadPoolMetricsSampler threadPoolSampler = new ThreadPoolMetricsSampler(this);
    private String applicationName;
    private ApplicationModel applicationModel;
    private final List<MetricsSampler> samplers = new ArrayList<MetricsSampler>();
    public SimpleMetricsCountSampler<String, MetricsEvent.Type, ApplicationMetric> applicationSampler = new SimpleMetricsCountSampler<String, MetricsEvent.Type, ApplicationMetric>(){

        @Override
        public List<MetricSample> sample() {
            ArrayList<MetricSample> samples = new ArrayList<MetricSample>();
            this.getCount(MetricsEvent.Type.APPLICATION_INFO).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> samples.add(new GaugeMetricSample<AtomicLong>(MetricsKey.APPLICATION_METRIC_INFO, k.getTags(), MetricsCategory.APPLICATION, (AtomicLong)v, AtomicLong::get))));
            return samples;
        }

        @Override
        protected void countConfigure(MetricsCountSampleConfigurer<String, MetricsEvent.Type, ApplicationMetric> sampleConfigure) {
            sampleConfigure.configureMetrics(configure -> new ApplicationMetric((String)sampleConfigure.getSource()));
        }
    };

    public DefaultMetricsCollector() {
        this.eventMulticaster = new SimpleMetricsEventMulticaster();
        this.samplers.add(this.methodSampler);
        this.samplers.add(this.applicationSampler);
        this.samplers.add(this.threadPoolSampler);
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public SimpleMetricsEventMulticaster getEventMulticaster() {
        return this.eventMulticaster;
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        this.collectEnabled = collectEnabled;
    }

    @Override
    public boolean isCollectEnabled() {
        return this.collectEnabled;
    }

    public MethodMetricsSampler getMethodSampler() {
        return this.methodSampler;
    }

    public ThreadPoolMetricsSampler getThreadPoolSampler() {
        return this.threadPoolSampler;
    }

    public void collectApplication(ApplicationModel applicationModel) {
        this.setApplicationName(applicationModel.getApplicationName());
        this.applicationModel = applicationModel;
        this.applicationSampler.inc(this.applicationName, MetricsEvent.Type.APPLICATION_INFO);
    }

    public void registryDefaultSample() {
        this.threadPoolSampler.registryDefaultSampleThreadPoolExecutor();
    }

    @Override
    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        for (MetricsSampler sampler : this.samplers) {
            List<MetricSample> sample = sampler.sample();
            list.addAll(sample);
        }
        return list;
    }

    public void addListener(MetricsListener listener) {
        this.eventMulticaster.addListener(listener);
    }
}

