/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.AggregationConfig;
import org.apache.dubbo.metrics.aggregate.TimeWindowCounter;
import org.apache.dubbo.metrics.aggregate.TimeWindowQuantile;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.MetricsCollector;
import org.apache.dubbo.metrics.event.MethodEvent;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.RTEvent;
import org.apache.dubbo.metrics.listener.MetricsListener;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class AggregateMetricsCollector
implements MetricsCollector,
MetricsListener {
    private int bucketNum;
    private int timeWindowSeconds;
    private final Map<String, ConcurrentHashMap<MethodMetric, TimeWindowCounter>> methodTypeCounter = new ConcurrentHashMap<String, ConcurrentHashMap<MethodMetric, TimeWindowCounter>>();
    private final ConcurrentMap<MethodMetric, TimeWindowQuantile> rt = new ConcurrentHashMap<MethodMetric, TimeWindowQuantile>();
    private final ConcurrentHashMap<MethodMetric, TimeWindowCounter> qps = new ConcurrentHashMap();
    private final ApplicationModel applicationModel;
    private static final Integer DEFAULT_COMPRESSION = 100;
    private static final Integer DEFAULT_BUCKET_NUM = 10;
    private static final Integer DEFAULT_TIME_WINDOW_SECONDS = 120;

    public AggregateMetricsCollector(ApplicationModel applicationModel) {
        this.registryEventTypeHandler();
        this.applicationModel = applicationModel;
        ConfigManager configManager = applicationModel.getApplicationConfigManager();
        MetricsConfig config = configManager.getMetrics().orElse(null);
        if (config != null && config.getAggregation() != null && Boolean.TRUE.equals(config.getAggregation().getEnabled())) {
            this.registerListener();
            AggregationConfig aggregation = config.getAggregation();
            this.bucketNum = aggregation.getBucketNum() == null ? DEFAULT_BUCKET_NUM : aggregation.getBucketNum();
            this.timeWindowSeconds = aggregation.getTimeWindowSeconds() == null ? DEFAULT_TIME_WINDOW_SECONDS : aggregation.getTimeWindowSeconds();
        }
    }

    public void onEvent(MetricsEvent event) {
        if (event instanceof RTEvent) {
            this.onRTEvent((RTEvent)event);
        } else if (event instanceof MethodEvent) {
            this.onRequestEvent((MethodEvent)event);
        }
    }

    private void onRTEvent(RTEvent event) {
        MethodMetric metric = (MethodMetric)event.getSource();
        Long responseTime = event.getRt();
        TimeWindowQuantile quantile = ConcurrentHashMapUtils.computeIfAbsent(this.rt, metric, k -> new TimeWindowQuantile(DEFAULT_COMPRESSION.intValue(), this.bucketNum, this.timeWindowSeconds));
        quantile.add(responseTime.longValue());
    }

    private void onRequestEvent(MethodEvent event) {
        MethodMetric metric = (MethodMetric)event.getSource();
        String type = event.getType();
        ConcurrentMap counter = this.methodTypeCounter.get(type);
        if (counter == null) {
            return;
        }
        TimeWindowCounter windowCounter = ConcurrentHashMapUtils.computeIfAbsent(counter, metric, methodMetric -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
        if (MetricsEvent.Type.TOTAL.getNameByType("provider").equals(type) || MetricsEvent.Type.TOTAL.getNameByType("consumer").equals(type)) {
            TimeWindowCounter qpsCounter = ConcurrentHashMapUtils.computeIfAbsent(this.qps, metric, methodMetric -> new TimeWindowCounter(this.bucketNum, this.timeWindowSeconds));
            qpsCounter.increment();
        }
        windowCounter.increment();
    }

    @Override
    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        this.collectRequests(list);
        this.collectQPS(list);
        this.collectRT(list);
        return list;
    }

    private void collectRequests(List<MetricSample> list) {
        this.collectBySide(list, "provider");
        this.collectBySide(list, "consumer");
    }

    private void collectBySide(List<MetricSample> list, String side) {
        this.collectMethod(list, MetricsEvent.Type.TOTAL.getNameByType(side), MetricsKey.METRIC_REQUESTS_TOTAL_AGG);
        this.collectMethod(list, MetricsEvent.Type.SUCCEED.getNameByType(side), MetricsKey.METRIC_REQUESTS_SUCCEED_AGG);
        this.collectMethod(list, MetricsEvent.Type.UNKNOWN_FAILED.getNameByType(side), MetricsKey.METRIC_REQUESTS_FAILED_AGG);
        this.collectMethod(list, MetricsEvent.Type.BUSINESS_FAILED.getNameByType(side), MetricsKey.METRIC_REQUESTS_BUSINESS_FAILED_AGG);
        this.collectMethod(list, MetricsEvent.Type.REQUEST_TIMEOUT.getNameByType(side), MetricsKey.METRIC_REQUESTS_TIMEOUT_AGG);
        this.collectMethod(list, MetricsEvent.Type.REQUEST_LIMIT.getNameByType(side), MetricsKey.METRIC_REQUESTS_LIMIT_AGG);
        this.collectMethod(list, MetricsEvent.Type.TOTAL_FAILED.getNameByType(side), MetricsKey.METRIC_REQUESTS_TOTAL_FAILED_AGG);
        this.collectMethod(list, MetricsEvent.Type.NETWORK_EXCEPTION.getNameByType(side), MetricsKey.METRIC_REQUESTS_TOTAL_NETWORK_FAILED_AGG);
        this.collectMethod(list, MetricsEvent.Type.CODEC_EXCEPTION.getNameByType(side), MetricsKey.METRIC_REQUESTS_TOTAL_CODEC_FAILED_AGG);
        this.collectMethod(list, MetricsEvent.Type.SERVICE_UNAVAILABLE.getNameByType(side), MetricsKey.METRIC_REQUESTS_TOTAL_SERVICE_UNAVAILABLE_FAILED_AGG);
    }

    private void collectMethod(List<MetricSample> list, String eventType, MetricsKey metricsKey) {
        ConcurrentHashMap<MethodMetric, TimeWindowCounter> windowCounter = this.methodTypeCounter.get(eventType);
        if (windowCounter != null) {
            windowCounter.forEach((k, v) -> list.add(new GaugeMetricSample<TimeWindowCounter>(metricsKey.getNameByType(k.getSide()), metricsKey.getDescription(), k.getTags(), MetricsCategory.REQUESTS, (TimeWindowCounter)v, TimeWindowCounter::get)));
        }
    }

    private void collectQPS(List<MetricSample> list) {
        this.qps.forEach((k, v) -> list.add(new GaugeMetricSample<TimeWindowCounter>(MetricsKey.METRIC_QPS.getNameByType(k.getSide()), MetricsKey.METRIC_QPS.getDescription(), k.getTags(), MetricsCategory.QPS, (TimeWindowCounter)v, value -> value.get() / (double)value.bucketLivedSeconds())));
    }

    private void collectRT(List<MetricSample> list) {
        this.rt.forEach((k, v) -> {
            list.add(new GaugeMetricSample<TimeWindowQuantile>(MetricsKey.METRIC_RT_P99.getNameByType(k.getSide()), MetricsKey.METRIC_RT_P99.getDescription(), k.getTags(), MetricsCategory.RT, (TimeWindowQuantile)v, value -> value.quantile(0.99)));
            list.add(new GaugeMetricSample<TimeWindowQuantile>(MetricsKey.METRIC_RT_P95.getNameByType(k.getSide()), MetricsKey.METRIC_RT_P99.getDescription(), k.getTags(), MetricsCategory.RT, (TimeWindowQuantile)v, value -> value.quantile(0.95)));
        });
    }

    private void registryEventTypeHandler() {
        this.registryBySide("provider");
        this.registryBySide("consumer");
    }

    private void registryBySide(String side) {
        this.methodTypeCounter.put(MetricsEvent.Type.TOTAL.getNameByType(side), new ConcurrentHashMap());
        this.methodTypeCounter.put(MetricsEvent.Type.SUCCEED.getNameByType(side), new ConcurrentHashMap());
        this.methodTypeCounter.put(MetricsEvent.Type.UNKNOWN_FAILED.getNameByType(side), new ConcurrentHashMap());
        this.methodTypeCounter.put(MetricsEvent.Type.BUSINESS_FAILED.getNameByType(side), new ConcurrentHashMap());
        this.methodTypeCounter.put(MetricsEvent.Type.REQUEST_TIMEOUT.getNameByType(side), new ConcurrentHashMap());
        this.methodTypeCounter.put(MetricsEvent.Type.REQUEST_LIMIT.getNameByType(side), new ConcurrentHashMap());
        this.methodTypeCounter.put(MetricsEvent.Type.TOTAL_FAILED.getNameByType(side), new ConcurrentHashMap());
        this.methodTypeCounter.put(MetricsEvent.Type.SERVICE_UNAVAILABLE.getNameByType(side), new ConcurrentHashMap());
        this.methodTypeCounter.put(MetricsEvent.Type.NETWORK_EXCEPTION.getNameByType(side), new ConcurrentHashMap());
        this.methodTypeCounter.put(MetricsEvent.Type.CODEC_EXCEPTION.getNameByType(side), new ConcurrentHashMap());
    }

    private void registerListener() {
        this.applicationModel.getBeanFactory().getBean(DefaultMetricsCollector.class).addListener(this);
    }
}

