/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.metadata.MetadataConstants;
import org.apache.dubbo.metadata.rest.JAXRSClassConstants;
import org.apache.dubbo.metadata.rest.SpringMvcClassConstants;
import org.apache.dubbo.metadata.rest.tag.BodyTag;

public enum ParamType {
    HEADER(ParamType.addSupportTypes(JAXRSClassConstants.HEADER_PARAM_ANNOTATION_CLASS, SpringMvcClassConstants.REQUEST_HEADER_ANNOTATION_CLASS)),
    PARAM(ParamType.addSupportTypes(JAXRSClassConstants.QUERY_PARAM_ANNOTATION_CLASS, SpringMvcClassConstants.REQUEST_PARAM_ANNOTATION_CLASS)),
    BODY(ParamType.addSupportTypes(JAXRSClassConstants.REST_EASY_BODY_ANNOTATION_CLASS, SpringMvcClassConstants.REQUEST_BODY_ANNOTATION_CLASS, BodyTag.class)),
    REQ_OR_RES(ParamType.addSupportTypes(MetadataConstants.JAKARTA_SERVLET_REQ_CLASS, MetadataConstants.JAKARTA_SERVLET_RES_CLASS, MetadataConstants.JAVAX_SERVLET_REQ_CLASS, MetadataConstants.JAKARTA_SERVLET_RES_CLASS)),
    PATH(ParamType.addSupportTypes(JAXRSClassConstants.PATH_PARAM_ANNOTATION_CLASS, SpringMvcClassConstants.PATH_VARIABLE_ANNOTATION_CLASS)),
    FORM(ParamType.addSupportTypes(JAXRSClassConstants.FORM_PARAM_ANNOTATION_CLASS)),
    EMPTY(ParamType.addSupportTypes(new Class[0]));

    private List<Class> annotationClasses;

    private ParamType(List<Class> annotationClasses) {
        this.annotationClasses = annotationClasses;
    }

    public boolean supportAnno(Class anno) {
        if (anno == null) {
            return false;
        }
        return this.annotationClasses.contains(anno);
    }

    public boolean isReqOrRes(Class clazz) {
        for (Class annotationClass : this.annotationClasses) {
            if (!annotationClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private static List<Class> addSupportTypes(Class ... classes) {
        ArrayList<Class> types = new ArrayList<Class>();
        for (Class clazz : classes) {
            if (clazz == null) continue;
            types.add(clazz);
        }
        return types;
    }
}

