/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.security.utils;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.security.jackson2.CoreJackson2Module;

public class ObjectMapperCodec {
    private ObjectMapper mapper = new ObjectMapper();

    public ObjectMapperCodec() {
        this.mapper.registerModule((Module)new CoreJackson2Module());
    }

    public <T> T deserialize(byte[] bytes, Class<T> clazz) {
        try {
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            return (T)this.mapper.readValue(bytes, clazz);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("objectMapper! deserialize error %s", exception));
        }
    }

    public <T> T deserialize(String content, Class<T> clazz) {
        if (StringUtils.isBlank(content)) {
            return null;
        }
        return this.deserialize(content.getBytes(), clazz);
    }

    public String serialize(Object object) {
        try {
            if (object == null) {
                return null;
            }
            return this.mapper.writeValueAsString(object);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("objectMapper! serialize error %s", ex));
        }
    }
}

