/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import com.alibaba.dubbo.rpc.service.GenericException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.dubbo.common.beanutil.JavaBeanAccessor;
import org.apache.dubbo.common.beanutil.JavaBeanDescriptor;
import org.apache.dubbo.common.beanutil.JavaBeanSerializeUtil;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.DefaultSerializeClassChecker;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"consumer"}, value={"generic"}, order=20000)
public class GenericImplFilter
implements Filter,
BaseFilter.Listener {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(GenericImplFilter.class);
    private static final Class<?>[] GENERIC_PARAMETER_TYPES = new Class[]{String.class, String[].class, Object[].class};
    private static final String GENERIC_IMPL_MARKER = "GENERIC_IMPL";
    private final ModuleModel moduleModel;

    public GenericImplFilter(ModuleModel moduleModel) {
        this.moduleModel = moduleModel;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String generic = invoker.getUrl().getParameter("generic");
        if (this.isCallingGenericImpl(generic, invocation)) {
            Object[] args;
            RpcInvocation invocation2 = new RpcInvocation(invocation);
            invocation2.put(GENERIC_IMPL_MARKER, true);
            String methodName = invocation2.getMethodName();
            Class<?>[] parameterTypes = invocation2.getParameterTypes();
            Object[] arguments = invocation2.getArguments();
            String[] types = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                types[i] = ReflectUtils.getName(parameterTypes[i]);
            }
            if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                args = new Object[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    args[i] = JavaBeanSerializeUtil.serialize(arguments[i], JavaBeanAccessor.METHOD);
                }
            } else {
                args = PojoUtils.generalize(arguments);
            }
            if (RpcUtils.isReturnTypeFuture(invocation)) {
                invocation2.setMethodName("$invokeAsync");
            } else {
                invocation2.setMethodName("$invoke");
            }
            invocation2.setParameterTypes(GENERIC_PARAMETER_TYPES);
            invocation2.setParameterTypesDesc("Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/Object;");
            invocation2.setArguments(new Object[]{methodName, types, args});
            return invoker.invoke(invocation2);
        }
        if (this.isMakingGenericCall(generic, invocation)) {
            Object[] args = (Object[])invocation.getArguments()[2];
            if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                for (Object arg : args) {
                    if (byte[].class == arg.getClass()) continue;
                    this.error(generic, byte[].class.getName(), arg.getClass().getName());
                }
            } else if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                for (Object arg : args) {
                    if (arg instanceof JavaBeanDescriptor) continue;
                    this.error(generic, JavaBeanDescriptor.class.getName(), arg.getClass().getName());
                }
            }
            invocation.setAttachment("generic", invoker.getUrl().getParameter("generic"));
        }
        return invoker.invoke(invocation);
    }

    private void error(String generic, String expected, String actual) throws RpcException {
        throw new RpcException("Generic serialization [" + generic + "] only support message type " + expected + " and your message type is " + actual);
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        block24: {
            String generic = invoker.getUrl().getParameter("generic");
            String methodName = invocation.getMethodName();
            Class<?>[] parameterTypes = invocation.getParameterTypes();
            Object genericImplMarker = invocation.get(GENERIC_IMPL_MARKER);
            if (genericImplMarker != null && ((Boolean)invocation.get(GENERIC_IMPL_MARKER)).booleanValue()) {
                if (!appResponse.hasException()) {
                    Object value = appResponse.getValue();
                    try {
                        Class<GenericService> invokerInterface = invoker.getInterface();
                        if (!"$invoke".equals(methodName) && !"$invokeAsync".equals(methodName) && invokerInterface.isAssignableFrom(GenericService.class)) {
                            try {
                                String realInterface = invoker.getUrl().getParameter("interface");
                                invokerInterface = ReflectUtils.forName(realInterface);
                            }
                            catch (Throwable realInterface) {
                                // empty catch block
                            }
                        }
                        Method method = invokerInterface.getMethod(methodName, parameterTypes);
                        if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                            if (value == null) {
                                appResponse.setValue(value);
                            }
                            if (value instanceof JavaBeanDescriptor) {
                                appResponse.setValue(JavaBeanSerializeUtil.deserialize((JavaBeanDescriptor)value));
                            }
                            throw new RpcException("The type of result value is " + value.getClass().getName() + " other than " + JavaBeanDescriptor.class.getName() + ", and the result is " + value);
                        }
                        Type[] types = ReflectUtils.getReturnTypes(method);
                        appResponse.setValue(PojoUtils.realize(value, (Class)types[0], types[1]));
                    }
                    catch (NoSuchMethodException e) {
                        throw new RpcException(e.getMessage(), (Throwable)e);
                    }
                } else if (appResponse.getException() instanceof GenericException) {
                    GenericException exception = (GenericException)appResponse.getException();
                    try {
                        String className = exception.getExceptionClass();
                        DefaultSerializeClassChecker classChecker = this.moduleModel.getApplicationModel().getFrameworkModel().getBeanFactory().getBean(DefaultSerializeClassChecker.class);
                        Class<?> clazz = classChecker.loadClass(Thread.currentThread().getContextClassLoader(), className);
                        Throwable targetException = null;
                        Throwable lastException = null;
                        try {
                            targetException = (Throwable)clazz.newInstance();
                        }
                        catch (Throwable e) {
                            lastException = e;
                            for (Constructor<?> constructor : clazz.getConstructors()) {
                                try {
                                    targetException = (Throwable)constructor.newInstance(new Object[constructor.getParameterTypes().length]);
                                    break;
                                }
                                catch (Throwable e1) {
                                    lastException = e1;
                                }
                            }
                        }
                        if (targetException != null) {
                            try {
                                Field field = Throwable.class.getDeclaredField("detailMessage");
                                if (!field.isAccessible()) {
                                    field.setAccessible(true);
                                }
                                field.set(targetException, exception.getExceptionMessage());
                            }
                            catch (Throwable e) {
                                logger.warn("0-8", "", "", e.getMessage(), e);
                            }
                            appResponse.setException(targetException);
                            break block24;
                        }
                        if (lastException != null) {
                            throw lastException;
                        }
                    }
                    catch (Throwable e) {
                        throw new RpcException("Can not deserialize exception " + exception.getExceptionClass() + ", message: " + exception.getExceptionMessage(), e);
                    }
                }
            }
        }
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }

    private boolean isCallingGenericImpl(String generic, Invocation invocation) {
        return ProtocolUtils.isGeneric(generic) && !"$invoke".equals(invocation.getMethodName()) && !"$invokeAsync".equals(invocation.getMethodName()) && invocation instanceof RpcInvocation;
    }

    private boolean isMakingGenericCall(String generic, Invocation invocation) {
        return (invocation.getMethodName().equals("$invoke") || invocation.getMethodName().equals("$invokeAsync")) && invocation.getArguments() != null && invocation.getArguments().length == 3 && ProtocolUtils.isGeneric(generic);
    }
}

